/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.stairs.vertical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;

public final class VerticalStairsShapes {
    public static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        VoxelShape topBothShape = ShapeUtils.orUnoptimized(Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0));
        VoxelShape bottomBothShape = ShapeUtils.orUnoptimized(Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0));
        CommonShapes.STRAIGHT_VERTICAL_STAIRS.forEach((dir, shape) -> map.put(new ShapeKey((Direction)dir, StairsType.VERTICAL), shape));
        ShapeUtils.makeHorizontalRotations(topBothShape, Direction.SOUTH, map, StairsType.TOP_CORNER, ShapeKey::new);
        ShapeUtils.makeHorizontalRotations(bottomBothShape, Direction.SOUTH, map, StairsType.BOTTOM_CORNER, ShapeKey::new);
    });

    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            StairsType type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
            builder.put((Object)state, (Object)SHAPES.get(new ShapeKey(dir, type)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private VerticalStairsShapes() {
    }

    public record ShapeKey(Direction dir, StairsType type) {
    }
}

