/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.GearSet;
import dev.shadowsoffire.placebo.json.GearSetRegistry;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;

public interface WaveModifier
extends CodecProvider<WaveModifier> {
    public static final CodecMap<WaveModifier> CODEC = new CodecMap("Gateway Wave Modifier");

    public void apply(LivingEntity var1);

    public void appendHoverText(Consumer<MutableComponent> var1);

    public static void initSerializers() {
        WaveModifier.register("mob_effect", EffectModifier.CODEC);
        WaveModifier.register("attribute", AttributeModifier.CODEC);
        WaveModifier.register("gear_set", GearSetModifier.CODEC);
        CODEC.setDefaultCodec(AttributeModifier.CODEC);
    }

    private static void register(String id, Codec<? extends WaveModifier> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public record EffectModifier(ChancedEffectInstance effect) implements WaveModifier
    {
        public static Codec<EffectModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ChancedEffectInstance.CONSTANT_CODEC.fieldOf("effect").forGetter(EffectModifier::effect)).apply((Applicative)inst, EffectModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity) {
            int duration = entity instanceof Creeper ? 6000 : Integer.MAX_VALUE;
            entity.m_7292_(this.effect.createDeterministic(duration));
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            ArrayList output = new ArrayList();
            PotionUtils.m_257410_(Arrays.asList(this.effect.createDeterministic(1)), output, (float)1.0f);
            list.accept(Component.m_237113_((String)((Component)output.get(0)).getString()));
        }
    }

    public record AttributeModifier(RandomAttributeModifier modifier) implements WaveModifier
    {
        public static Codec<AttributeModifier> CODEC = RandomAttributeModifier.CONSTANT_CODEC.xmap(AttributeModifier::new, AttributeModifier::modifier);

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity) {
            AttributeInstance inst = entity.m_21051_(this.modifier.attribute());
            if (inst == null) {
                return;
            }
            inst.m_22125_(this.modifier.createDeterministic());
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(IFormattableAttribute.toComponent((Attribute)this.modifier.getAttribute(), (net.minecraft.world.entity.ai.attributes.AttributeModifier)this.modifier.createDeterministic(), (TooltipFlag)AttributesLib.getTooltipFlag()));
        }
    }

    public record GearSetModifier(DynamicHolder<GearSet> set) implements WaveModifier
    {
        public static Codec<GearSetModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GearSetRegistry.INSTANCE.holderCodec().fieldOf("gear_set").forGetter(GearSetModifier::set)).apply((Applicative)inst, GearSetModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity) {
            ((GearSet)this.set.get()).apply(entity);
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"modifier.gateways.gear_set", (Object[])new Object[]{Component.m_237115_((String)this.set.getId().m_214296_("gear_set"))}));
        }
    }
}

