/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.gui.BlueprintInventory;
import blusunrize.immersiveengineering.common.gui.IEBaseContainerOld;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.ShaderInventory;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import blusunrize.immersiveengineering.mixin.accessors.ContainerAccess;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ModWorkbenchContainer
extends IEBaseContainerOld<ModWorkbenchBlockEntity> {
    public static final int MAX_NUM_DYNAMIC_SLOTS = 20;
    private final Level world;
    public Inventory inventoryPlayer;
    private BlueprintInventory inventoryBPoutput;
    public ShaderInventory shaderInv;
    private final ItemStackHandler clientInventory = new ItemStackHandler(21);

    public ModWorkbenchContainer(MenuType<?> type, int id, Inventory inventoryPlayer, ModWorkbenchBlockEntity tile) {
        super(type, tile, id);
        this.world = tile.getLevelNonnull();
        this.inventoryPlayer = inventoryPlayer;
        this.rebindSlots();
    }

    private void bindPlayerInv(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 87 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 145));
        }
    }

    public void rebindSlots() {
        this.f_38839_.clear();
        ((ContainerAccess)((Object)this)).getLastSlots().clear();
        ((ContainerAccess)((Object)this)).getRemoteSlots().clear();
        this.m_38897_(new IESlot.ModWorkbench(this, this.inv, 0, 24, 22, 1));
        this.ownSlotCount = 1;
        ItemStack tool = this.m_38853_(0).m_7993_();
        Item item = tool.m_41720_();
        if (item instanceof IUpgradeableTool) {
            Slot[] slots;
            IUpgradeableTool upgradeableTool = (IUpgradeableTool)item;
            IItemHandler toolInv = (IItemHandler)tool.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseThrow(RuntimeException::new);
            if (toolInv instanceof IEItemStackHandler) {
                IEItemStackHandler ieInv = (IEItemStackHandler)toolInv;
                ieInv.setTile(this.tile);
            }
            if ((slots = upgradeableTool.getWorkbenchSlots(this, tool, this.world, () -> this.inventoryPlayer.f_35978_, (IItemHandler)(this.world.f_46443_ ? this.clientInventory : toolInv))) != null) {
                for (Slot s : slots) {
                    this.m_38897_(s);
                    ++this.ownSlotCount;
                }
            }
            tool.getCapability(CapabilityShader.SHADER_CAPABILITY, null).ifPresent(wrapper -> {
                this.shaderInv = new ShaderInventory(this, (CapabilityShader.ShaderWrapper)wrapper);
                this.m_38897_(new IESlot.Shader(this, this.shaderInv, 0, 130, 32, tool));
                ++this.ownSlotCount;
                this.shaderInv.shader = wrapper.getShaderItem();
            });
        } else if (!(tool.m_41720_() instanceof IConfigurableTool)) {
            boolean blueprint = false;
            if (tool.m_41720_() instanceof EngineersBlueprintItem) {
                blueprint = true;
                BlueprintCraftingRecipe[] recipes = EngineersBlueprintItem.getRecipes(this.world, tool);
                this.inventoryBPoutput = new BlueprintInventory(this, recipes);
                for (int i = 0; i < recipes.length; ++i) {
                    int y = 21 + (i < 9 ? i / 3 : -(i - 6) / 3) * 18;
                    this.m_38897_(new IESlot.BlueprintOutput(this, this.inventoryBPoutput, this.inv, i, 118 + i % 3 * 18, y, recipes[i]));
                    ++this.ownSlotCount;
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (blueprint) {
                    this.m_38897_(new IESlot.BlueprintInput(this, this.inv, this.inventoryBPoutput, i + 1, i % 2 == 0 ? 74 : 92, 21 + i / 2 * 18));
                } else {
                    this.m_38897_(new Slot(this.inv, i + 1, i % 2 == 0 ? 74 : 92, 21 + i / 2 * 18));
                }
                ++this.ownSlotCount;
            }
            if (this.inventoryBPoutput != null) {
                this.inventoryBPoutput.updateOutputs(this.inv);
            }
        }
        while (this.ownSlotCount < 20) {
            this.m_38897_(new IESlot.AlwaysEmptySlot(this));
            ++this.ownSlotCount;
        }
        this.bindPlayerInv(this.inventoryPlayer);
        ImmersiveEngineering.proxy.reInitGui();
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        ItemStack resultStack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack stackInSlot = slotObject.m_7993_();
            resultStack = stackInSlot.m_41777_();
            if (slot < this.ownSlotCount) {
                if (!this.m_38903_(stackInSlot, this.ownSlotCount, this.ownSlotCount + 36, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (!stackInSlot.m_41619_()) {
                IConfigurableTool cTool;
                IUpgradeableTool uTool;
                Item item;
                boolean singleSlot;
                boolean bl = singleSlot = this.ownSlotCount == 1;
                if ((stackInSlot.m_41720_() instanceof EngineersBlueprintItem || (item = stackInSlot.m_41720_()) instanceof IUpgradeableTool && (uTool = (IUpgradeableTool)item).canModify(stackInSlot) || (item = stackInSlot.m_41720_()) instanceof IConfigurableTool && (cTool = (IConfigurableTool)item).canConfigure(stackInSlot)) && !this.m_38903_(stackInSlot, 0, 1, false) && singleSlot) {
                    return ItemStack.f_41583_;
                }
                if (!singleSlot && !this.m_38903_(stackInSlot, 1, this.ownSlotCount, false)) {
                    return ItemStack.f_41583_;
                }
            }
            slotObject.m_6654_();
            if (stackInSlot.m_41613_() == resultStack.m_41613_()) {
                resultStack = ItemStack.f_41583_;
            }
            slotObject.m_142406_(player, resultStack);
            if (slotObject.m_6657_()) {
                player.m_36176_(slotObject.m_7993_(), false);
            }
        }
        return resultStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return IEContainerMenu.moveItemStackToWithMayPlace((List<Slot>)this.f_38839_, (x$0, x$1, x$2, x$3) -> super.m_38903_(x$0, x$1, x$2, x$3), stack, startIndex, endIndex);
    }

    @Override
    public void m_150399_(int id, int dragType, ClickType clickType, Player player) {
        super.m_150399_(id, dragType, clickType, player);
        ((ModWorkbenchBlockEntity)this.tile).markContainingBlockForUpdate(null);
        if (!this.world.f_46443_) {
            this.m_38946_();
        }
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.inventoryBPoutput && super.m_5882_(pStack, pSlot);
    }
}

