/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;

public interface IPartState<P extends IPartType> {
    public static final String GLOBALCOUNTER_KEY = "part";

    public void writeToNBT(CompoundTag var1);

    public void readFromNBT(ValueDeseralizationContext var1, CompoundTag var2);

    public void generateId();

    public int getId();

    public void setUpdateInterval(int var1);

    public int getUpdateInterval();

    @Deprecated
    public void setPriority(int var1);

    public int getPriority();

    @Deprecated
    public void setChannel(int var1);

    public int getChannel();

    public Vec3i getTargetOffset();

    public void setTargetOffset(Vec3i var1);

    public void setTargetSideOverride(@Nullable Direction var1);

    @Nullable
    public Direction getTargetSideOverride();

    public void markDirty();

    public boolean isDirtyAndReset();

    public boolean isUpdateAndReset();

    public void forceBlockRenderUpdate();

    public boolean isForceBlockRenderUpdateAndReset();

    public IAspectProperties getAspectProperties(IAspect var1);

    public void setAspectProperties(IAspect var1, IAspectProperties var2);

    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public void gatherCapabilities(P var1);

    public <T> LazyOptional<T> getCapability(Capability<T> var1, INetwork var2, IPartNetwork var3, PartTarget var4);

    public <T> void addVolatileCapability(Capability<T> var1, LazyOptional<T> var2);

    public void removeVolatileCapability(Capability<?> var1);

    default public void loadInventoryNamed(String name, Container inventory) {
        NonNullList<ItemStack> tabItems = this.getInventoryNamed(name);
        if (tabItems != null) {
            for (int i = 0; i < tabItems.size(); ++i) {
                inventory.m_6836_(i, (ItemStack)tabItems.get(i));
            }
        }
    }

    default public void saveInventoryNamed(String name, Container inventory) {
        NonNullList latestItems = NonNullList.m_122779_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            latestItems.add((Object)inventory.m_8020_(i));
        }
        this.setInventoryNamed(name, (NonNullList<ItemStack>)latestItems);
    }

    @Nullable
    public NonNullList<ItemStack> getInventoryNamed(String var1);

    public void setInventoryNamed(String var1, NonNullList<ItemStack> var2);

    public Map<String, NonNullList<ItemStack>> getInventoriesNamed();

    public void clearInventoriesNamed();

    public void initializeOffsets(PartTarget var1);

    public void updateOffsetVariables(P var1, INetwork var2, IPartNetwork var3, PartTarget var4);

    public void markOffsetVariablesChanged();

    @Nullable
    public MutableComponent getOffsetVariableError(int var1);

    public boolean requiresOffsetUpdates();

    public int getMaxOffset();

    public void setMaxOffset(int var1);
}

