/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;

public class TextValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        String[] lines;
        Font fontRenderer = context.m_173586_();
        float maxWidth = 0.0f;
        for (String line : lines = value.getType().toCompactString(value).getString().split("(?<=[^\\\\])\\\\n")) {
            float width = fontRenderer.m_92895_(this.polishLine(line)) - 1;
            maxWidth = Math.max(maxWidth, width);
        }
        Objects.requireNonNull(fontRenderer);
        float singleHeight = 9.0f;
        float totalHeight = singleHeight * (float)lines.length;
        matrixStack.m_85836_();
        float scaleX = 12.5f / (maxWidth * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = maxWidth * scale;
        float newHeight = totalHeight * scale;
        matrixStack.m_252880_((12.5f - newWidth) / 2.0f, (12.5f - newHeight) / 2.0f, 0.0f);
        matrixStack.m_85841_(scale, scale, 1.0f);
        int offset = 0;
        for (String line : lines) {
            int color = Helpers.addAlphaToColor((int)value.getType().getDisplayColor(), (float)alpha);
            context.m_173586_().m_271703_(this.polishLine(line), 0.0f, (float)offset, color, false, matrixStack.m_85850_().m_252922_(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            offset = (int)((float)offset + singleHeight);
        }
        matrixStack.m_85849_();
    }

    protected String polishLine(String line) {
        return line.replaceAll("\\\\\\\\n", "\\\\n");
    }
}

