/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.InvalidValueTypeException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeLightLevelRegistry;

public class ValueTypeLightLevelRegistry
implements IValueTypeLightLevelRegistry {
    private static ValueTypeLightLevelRegistry INSTANCE = new ValueTypeLightLevelRegistry();
    private final Map<IValueType<?>, IValueTypeLightLevelRegistry.ILightLevelCalculator> lightLevelCalculatorMap = Maps.newHashMap();

    private ValueTypeLightLevelRegistry() {
    }

    public static ValueTypeLightLevelRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <L extends IValueTypeLightLevelRegistry.ILightLevelCalculator<V>, V extends IValue> L register(IValueType<V> valueType, L lightLevelCalculator) {
        this.lightLevelCalculatorMap.put(valueType, lightLevelCalculator);
        return lightLevelCalculator;
    }

    @Override
    @Nullable
    public <V extends IValue> IValueTypeLightLevelRegistry.ILightLevelCalculator<V> getLightLevelCalculator(IValueType<V> valueType) {
        return this.lightLevelCalculatorMap.get(valueType);
    }

    @Override
    public <V extends IValue> int getLightLevel(V value) throws InvalidValueTypeException {
        IValueType valueType = value.getType();
        IValueTypeLightLevelRegistry.ILightLevelCalculator<V> lightLevelCalculator = this.getLightLevelCalculator(valueType);
        if (lightLevelCalculator != null) {
            return lightLevelCalculator.getLightLevel(value);
        }
        for (Map.Entry<IValueType<?>, IValueTypeLightLevelRegistry.ILightLevelCalculator> entry : this.lightLevelCalculatorMap.entrySet()) {
            if (!value.canCast(entry.getKey())) continue;
            return entry.getValue().getLightLevel(value.cast(entry.getKey()));
        }
        throw new InvalidValueTypeException(Component.m_237110_((String)"valuetype.integrateddynamics.error.no_light_calculator", (Object[])new Object[]{value}));
    }
}

