/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.IEnergyConsumingNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.NetworkElementBase;

public class PartNetworkElement<P extends IPartType<P, S>, S extends IPartState<P>>
extends NetworkElementBase
implements IPartNetworkElement<P, S>,
IEnergyConsumingNetworkElement {
    private final P part;
    private final PartPos center;
    private S tempState = null;

    public PartNetworkElement(P part, PartPos center) {
        this.part = part;
        this.center = center;
    }

    protected static DimPos getCenterPos(PartTarget target) {
        return target.getCenter().getPos();
    }

    protected static Direction getCenterSide(PartTarget target) {
        return target.getCenter().getSide();
    }

    protected static DimPos getTargetPos(PartTarget target) {
        return target.getTarget().getPos();
    }

    protected static Direction getTargetSide(PartTarget target) {
        return target.getTarget().getSide();
    }

    @Override
    public P getPart() {
        return this.part;
    }

    @Override
    public PartTarget getTarget() {
        return this.getPart().getTarget(this.center, this.getPartState());
    }

    public PartTarget getTarget(S partState) {
        return this.getPart().getTarget(this.center, partState);
    }

    public S getTempState() {
        return this.tempState;
    }

    public void setTempState(S tempState) {
        this.tempState = tempState;
    }

    @Override
    public IPartContainer getPartContainer() {
        return PartHelpers.getPartContainerChecked(this.center.getPos(), this.center.getSide());
    }

    public LazyOptional<IPartContainer> getPartContainerOptional() {
        return PartHelpers.getPartContainer(this.center.getPos(), this.center.getSide());
    }

    @Override
    public void setPriorityAndChannel(INetwork network, int priority, int channel) {
        this.part.setPriorityAndChannel(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState(), priority, channel);
    }

    @Override
    public int getPriority() {
        return this.hasPartState() ? this.part.getPriority(this.getPartState()) : 0;
    }

    @Override
    public int getChannel() {
        return this.hasPartState() ? this.part.getChannel(this.getPartState()) : 0;
    }

    @Override
    public boolean canRevalidate(INetwork network) {
        return this.canRevalidatePositioned(network, this.center.getPos());
    }

    @Override
    public void revalidate(INetwork network) {
        super.revalidate(network);
        this.revalidatePositioned(network, this.center.getPos());
    }

    @Override
    public boolean isLoaded() {
        return this.center.getPos().isLoaded();
    }

    public boolean hasPartState() {
        if (this.isLoaded()) {
            return this.getPartContainerOptional().map(partContainer -> partContainer.hasPart(this.center.getSide())).orElse(false);
        }
        return false;
    }

    @Override
    public S getPartState() throws PartStateException {
        IPartContainer partContainer = this.getPartContainer();
        if (partContainer != null) {
            return (S)partContainer.getPartState(this.center.getSide());
        }
        throw new PartStateException(this.center.getPos(), this.center.getSide());
    }

    @Override
    public int getConsumptionRate() {
        return this.getPart().getConsumptionRate(this.getPartState());
    }

    @Override
    public void postUpdate(INetwork network, boolean updated) {
        this.part.postUpdate(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState(), updated);
    }

    @Override
    public int getUpdateInterval() {
        return this.part.getUpdateInterval(this.getPartState());
    }

    @Override
    public boolean isUpdate() {
        return this.part.isUpdate(this.getPartState());
    }

    @Override
    public void update(INetwork network) {
        this.part.update(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState());
    }

    @Override
    public void beforeNetworkKill(INetwork network) {
        this.part.beforeNetworkKill(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState());
    }

    @Override
    public void afterNetworkAlive(INetwork network) {
        this.part.afterNetworkAlive(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState());
    }

    @Override
    public void afterNetworkReAlive(INetwork network) {
        this.part.afterNetworkReAlive(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState());
    }

    @Override
    public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        this.part.addDrops(this.getTarget(), this.getPartState(), itemStacks, dropMainElement, saveState);
    }

    @Override
    public boolean onNetworkAddition(INetwork network) {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
        boolean res = partNetwork.addPart(this.getPartState().getId(), this.center);
        if (res) {
            this.part.onNetworkAddition(network, partNetwork, this.getTarget(), this.getPartState());
        }
        return res;
    }

    @Override
    public void onNetworkRemoval(INetwork network) {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
        partNetwork.removePart(this.getPartState().getId());
        this.part.onNetworkRemoval(network, partNetwork, this.getTarget(), this.getPartState());
    }

    @Override
    public void onPreRemoved(INetwork network) {
        this.tempState = this.getPartState();
        this.part.onPreRemoved(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.tempState);
    }

    @Override
    public void onPostRemoved(INetwork network) {
        this.part.onPostRemoved(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(this.tempState), (IPartState)((IPartState)Objects.requireNonNull(this.tempState)));
        this.tempState = null;
    }

    @Override
    public void onNeighborBlockChange(@Nullable INetwork network, BlockGetter world, Block neighbourBlock, BlockPos neighbourBlockPos) {
        this.part.onBlockNeighborChange(network, NetworkHelpers.getPartNetworkChecked(network), this.getTarget(), this.getPartState(), world, neighbourBlock, neighbourBlockPos);
    }

    @Override
    public Optional<P> getNetworkEventListener() {
        return Optional.of(this.getPart());
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof IPartNetworkElement && this.compareTo((INetworkElement)o) == 0;
    }

    @Override
    public int hashCode() {
        int result = this.part.hashCode();
        result = 31 * result + this.center.hashCode();
        return result;
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof IPartNetworkElement) {
            IPartNetworkElement p = (IPartNetworkElement)o;
            int compClass = this.getPart().getUniqueName().compareTo(p.getPart().getUniqueName());
            if (compClass == 0) {
                int compPriority;
                int n = compPriority = !this.isLoaded() || !p.isLoaded() ? 0 : -Integer.compare(this.getPriority(), p.getPriority());
                if (compPriority == 0) {
                    int compPart = this.getPart().getTranslationKey().compareTo(p.getPart().getTranslationKey());
                    if (compPart == 0) {
                        int compPos = this.center.getPos().compareTo(p.getPosition());
                        if (compPos == 0) {
                            return this.center.getSide().compareTo((Enum)p.getSide());
                        }
                        return compPos;
                    }
                    return compPart;
                }
                return compPriority;
            }
            return compClass;
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public DimPos getPosition() {
        return this.center.getPos();
    }

    @Override
    public Direction getSide() {
        return this.center.getSide();
    }

    @Override
    public int getId() {
        if (!this.hasPartState()) {
            return -1;
        }
        return this.getPartState().getId();
    }

    @Override
    public ResourceLocation getGroup() {
        return IPartNetworkElement.GROUP;
    }
}

