/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.util.Optional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPositionedNetworkElement;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.network.ConsumingNetworkElementBase;

public abstract class TileNetworkElement<T extends BlockEntityCableConnectableInventory>
extends ConsumingNetworkElementBase
implements IPositionedNetworkElement {
    private final DimPos pos;

    protected abstract Class<T> getTileClass();

    protected Optional<T> getTile() {
        return BlockEntityHelpers.get((DimPos)this.getPos(), this.getTileClass());
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof TileNetworkElement) {
            return this.getPos().compareTo(((TileNetworkElement)o).getPos());
        }
        return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
    }

    @Override
    public void afterNetworkReAlive(INetwork network) {
        super.afterNetworkReAlive(network);
        this.getTile().ifPresent(BlockEntityCableConnectableInventory::afterNetworkReAlive);
    }

    @Override
    public boolean canRevalidate(INetwork network) {
        return this.canRevalidatePositioned(network, this.pos);
    }

    @Override
    public void revalidate(INetwork network) {
        super.revalidate(network);
        this.revalidatePositioned(network, this.pos);
    }

    @Override
    public DimPos getPosition() {
        return this.pos;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TileNetworkElement)) {
            return false;
        }
        TileNetworkElement other = (TileNetworkElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DimPos this$pos = this.getPos();
        DimPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TileNetworkElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DimPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    public TileNetworkElement(DimPos pos) {
        this.pos = pos;
    }

    public DimPos getPos() {
        return this.pos;
    }

    @Override
    public String toString() {
        return "TileNetworkElement(pos=" + this.getPos() + ")";
    }
}

