/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.modcompat.integratedcrafting;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.FailedCraftingRecipeException;
import org.cyclops.integratedcrafting.api.crafting.ICraftingInterface;
import org.cyclops.integratedcrafting.api.crafting.RecursiveCraftingRecipeException;
import org.cyclops.integratedcrafting.api.crafting.UnavailableCraftingInterfacesException;
import org.cyclops.integratedcrafting.api.crafting.UnknownCraftingRecipeException;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.api.recipe.IRecipeIndex;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.MissingIngredients;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.CraftingJobStartException;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanStatic;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.modcompat.integratedcrafting.IntegratedCraftingHelpers;
import org.cyclops.integratedterminals.modcompat.integratedcrafting.TerminalCraftingOptionRecipeDefinition;
import org.cyclops.integratedterminals.modcompat.integratedcrafting.TerminalCraftingPlanCraftingJobDependencyGraph;

public class TerminalStorageTabIngredientCraftingHandlerCraftingNetwork
implements ITerminalStorageTabIngredientCraftingHandler<TerminalCraftingOptionRecipeDefinition<?, ?>, Integer> {
    private static final ResourceLocation ID = new ResourceLocation("integratedcrafting", "crafting_network");

    protected IRecipeIndex getRecipeIndex(INetwork network, int channel) {
        ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked((INetwork)network);
        return craftingNetwork.getRecipeIndex(channel);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public <T, M> int[] getChannels(TerminalStorageTabIngredientComponentServer<T, M> tab) {
        INetwork network = tab.getNetwork();
        ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked((INetwork)network);
        return craftingNetwork.getChannels();
    }

    @Override
    public <T, M> Collection<TerminalCraftingOptionRecipeDefinition<?, ?>> getCraftingOptions(TerminalStorageTabIngredientComponentServer<T, M> tab, int channel) {
        IngredientComponent ingredientComponent = tab.getIngredientNetwork().getComponent();
        IIngredientMatcher matcher = ingredientComponent.getMatcher();
        return this.getCraftingOptionsWithOutput(tab, channel, matcher.getEmptyInstance(), matcher.getAnyMatchCondition());
    }

    @Override
    public <T, M> Collection<TerminalCraftingOptionRecipeDefinition<?, ?>> getCraftingOptionsWithOutput(TerminalStorageTabIngredientComponentServer<T, M> tab, int channel, T instance, M matchCondition) {
        IngredientComponent ingredientComponent = tab.getIngredientNetwork().getComponent();
        IRecipeIndex recipeIndex = this.getRecipeIndex(tab.getNetwork(), channel);
        Iterable recipes = () -> recipeIndex.getRecipes(ingredientComponent, instance, matchCondition);
        return StreamSupport.stream(recipes.spliterator(), false).map(recipe -> new TerminalCraftingOptionRecipeDefinition(ingredientComponent, (IRecipeDefinition)recipe)).collect(Collectors.toList());
    }

    @Override
    public CompoundTag serializeCraftingOption(TerminalCraftingOptionRecipeDefinition craftingOption) {
        return IRecipeDefinition.serialize((IRecipeDefinition)craftingOption.getRecipe());
    }

    @Override
    public <T, M> TerminalCraftingOptionRecipeDefinition deserializeCraftingOption(IngredientComponent<T, M> ingredientComponent, CompoundTag tag) throws IllegalArgumentException {
        return new TerminalCraftingOptionRecipeDefinition<T, M>(ingredientComponent, (IRecipeDefinition)IRecipeDefinition.deserialize((CompoundTag)tag));
    }

    @Override
    public ITerminalCraftingPlan<Integer> calculateCraftingPlan(INetwork network, int channel, ITerminalCraftingOption craftingOption, long quantity) {
        TerminalCraftingOptionRecipeDefinition safeCraftingOption = (TerminalCraftingOptionRecipeDefinition)craftingOption;
        IRecipeDefinition recipe = safeCraftingOption.getRecipe();
        CraftingJobDependencyGraph dependencyGraph = new CraftingJobDependencyGraph();
        try {
            CraftingJob rootJob = CraftingHelpers.calculateCraftingJobs((INetwork)network, (int)channel, (IRecipeDefinition)recipe, (int)((int)quantity), (boolean)true, (CraftingHelpers.IIdentifierGenerator)CraftingHelpers.getGlobalCraftingJobIdentifier(), (CraftingJobDependencyGraph)dependencyGraph, (boolean)true);
            return TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlan(rootJob, dependencyGraph, true);
        }
        catch (FailedCraftingRecipeException e) {
            return TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlanFailed(e, dependencyGraph);
        }
        catch (RecursiveCraftingRecipeException e) {
            return TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlanErrorRecursive(Lists.reverse((List)e.getRecipeStack()));
        }
    }

    protected static ITerminalCraftingPlan<Integer> newCraftingPlan(CraftingJob craftingJob, CraftingJobDependencyGraph dependencyGraph, boolean root) {
        List<IPrototypedIngredient<?, ?>> recipeOutputs = IntegratedCraftingHelpers.getPrototypesFromIngredients(craftingJob.getRecipe().getOutput());
        List dependencies = dependencyGraph.getDependencies(craftingJob).stream().map(subCraftingJob -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlan(subCraftingJob, dependencyGraph, false)).collect(Collectors.toList());
        if (root) {
            return new TerminalCraftingPlanCraftingJobDependencyGraph(craftingJob.getId(), dependencies, CraftingHelpers.multiplyPrototypedIngredients(recipeOutputs, (long)craftingJob.getAmount()), TerminalCraftingJobStatus.UNSTARTED, craftingJob.getAmount(), IntegratedCraftingHelpers.getPrototypesFromIngredients(craftingJob.getIngredientsStorage()), Collections.emptyList(), TerminalCraftingPlanStatic.Label.VALID, -1L, craftingJob.getChannel(), null, dependencyGraph);
        }
        return new TerminalCraftingPlanStatic<Integer>(craftingJob.getId(), dependencies, CraftingHelpers.multiplyPrototypedIngredients(recipeOutputs, (long)craftingJob.getAmount()), TerminalCraftingJobStatus.UNSTARTED, craftingJob.getAmount(), IntegratedCraftingHelpers.getPrototypesFromIngredients(craftingJob.getIngredientsStorage()), Collections.emptyList(), TerminalCraftingPlanStatic.Label.VALID, -1L, craftingJob.getChannel(), null);
    }

    protected static ITerminalCraftingPlan<Integer> newCraftingPlanUnknown(UnknownCraftingRecipeException exception, CraftingJobDependencyGraph dependencyGraph) {
        ArrayList dependencies = Lists.newArrayList();
        dependencies.addAll(exception.getPartialCraftingJobs().stream().map(subCraftingJob -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlan(subCraftingJob, dependencyGraph, false)).collect(Collectors.toList()));
        dependencies.addAll(exception.getMissingChildRecipes().stream().map(subCraftingJob -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlanUnknown(subCraftingJob, dependencyGraph)).collect(Collectors.toList()));
        return new TerminalCraftingPlanStatic<Integer>(0, dependencies, Collections.singletonList(exception.getIngredient()), TerminalCraftingJobStatus.INVALID, exception.getQuantityMissing(), IntegratedCraftingHelpers.getPrototypesFromIngredients(exception.getIngredientsStorage()), Collections.emptyList(), TerminalCraftingPlanStatic.Label.INCOMPLETE, -1L, -1, null);
    }

    protected static ITerminalCraftingPlan<Integer> newCraftingPlanFailed(FailedCraftingRecipeException exception, CraftingJobDependencyGraph dependencyGraph) {
        ArrayList dependencies = Lists.newArrayList();
        dependencies.addAll(exception.getPartialCraftingJobs().stream().map(subCraftingJob -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlan(subCraftingJob, dependencyGraph, false)).collect(Collectors.toList()));
        dependencies.addAll(exception.getMissingChildRecipes().stream().map(subCraftingJob -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlanUnknown(subCraftingJob, dependencyGraph)).collect(Collectors.toList()));
        List<IPrototypedIngredient<?, ?>> recipeOutputs = IntegratedCraftingHelpers.getPrototypesFromIngredients(exception.getRecipe().getOutput());
        return new TerminalCraftingPlanStatic<Integer>(0, dependencies, CraftingHelpers.multiplyPrototypedIngredients(recipeOutputs, (long)exception.getQuantityMissing()), TerminalCraftingJobStatus.INVALID, exception.getQuantityMissing(), IntegratedCraftingHelpers.getPrototypesFromIngredients(exception.getIngredientsStorage()), Collections.emptyList(), TerminalCraftingPlanStatic.Label.INCOMPLETE, -1L, -1, null);
    }

    protected static ITerminalCraftingPlan<Integer> newCraftingPlanErrorRecursive(List<IRecipeDefinition> childRecipes) {
        List<IPrototypedIngredient<?, ?>> recipeOutputs = IntegratedCraftingHelpers.getPrototypesFromIngredients(childRecipes.get(0).getOutput());
        return new TerminalCraftingPlanStatic<Integer>(0, childRecipes.size() > 1 ? Lists.newArrayList((Object[])new ITerminalCraftingPlan[]{TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newCraftingPlanErrorRecursive(childRecipes.subList(1, childRecipes.size()))}) : Collections.emptyList(), recipeOutputs, TerminalCraftingJobStatus.INVALID, 0L, Collections.emptyList(), Collections.emptyList(), TerminalCraftingPlanStatic.Label.RECURSION, -1L, -1, null);
    }

    @Override
    public void startCraftingJob(INetwork network, int channel, ITerminalCraftingPlan<Integer> craftingPlan, ServerPlayer player) throws CraftingJobStartException {
        if (craftingPlan instanceof TerminalCraftingPlanCraftingJobDependencyGraph && craftingPlan.getStatus() == TerminalCraftingJobStatus.UNSTARTED) {
            CraftingJobDependencyGraph craftingJobDependencyGraph = ((TerminalCraftingPlanCraftingJobDependencyGraph)craftingPlan).getCraftingJobDependencyGraph();
            try {
                CraftingHelpers.scheduleCraftingJobs((ICraftingNetwork)CraftingHelpers.getCraftingNetworkChecked((INetwork)network), (CraftingJobDependencyGraph)craftingJobDependencyGraph, (boolean)true, (UUID)player.m_20148_());
            }
            catch (UnavailableCraftingInterfacesException e) {
                throw new CraftingJobStartException("gui.integratedterminals.terminal_storage.craftingplan.label.failed.insufficient_crafting_interfaces");
            }
        } else {
            IntegratedTerminals.clog(Level.WARN, "Tried to start an invalid crafting plan with status " + craftingPlan.getStatus());
        }
    }

    protected static ITerminalCraftingPlan<Integer> newErroredCraftingJob() {
        return new TerminalCraftingPlanStatic<Integer>(0, Collections.emptyList(), Collections.emptyList(), TerminalCraftingJobStatus.INVALID, 0L, Collections.emptyList(), Collections.emptyList(), TerminalCraftingPlanStatic.Label.ERROR, -1L, -1, null);
    }

    protected static ITerminalCraftingPlan<Integer> newActiveCraftingJob(ICraftingNetwork craftingNetwork, int channel, CraftingJob craftingJob, CraftingJobDependencyGraph dependencyGraph) {
        if (craftingJob == null) {
            return TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newErroredCraftingJob();
        }
        List<IPrototypedIngredient<?, ?>> recipeOutputs = IntegratedCraftingHelpers.getPrototypesFromIngredients(craftingJob.getRecipe().getOutput());
        List dependencies = dependencyGraph.getDependencies(craftingJob).stream().map(subCraftingJob -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newActiveCraftingJob(craftingNetwork, channel, subCraftingJob, dependencyGraph)).collect(Collectors.toList());
        int craftingJobId = craftingJob.getId();
        ICraftingInterface craftingInterface = craftingNetwork.getCraftingJobInterface(craftingJob.getChannel(), craftingJobId);
        if (craftingInterface == null) {
            return TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newErroredCraftingJob();
        }
        TerminalCraftingJobStatus jobStatus = TerminalCraftingJobStatus.UNSTARTED;
        switch (craftingInterface.getCraftingJobStatus(craftingNetwork, craftingJob.getChannel(), craftingJobId)) {
            case PENDING_INTERFACE: {
                jobStatus = TerminalCraftingJobStatus.QUEUEING;
                break;
            }
            case PENDING_DEPENDENCIES: {
                jobStatus = TerminalCraftingJobStatus.PENDING_DEPENDENCIES;
                break;
            }
            case PENDING_INGREDIENTS: {
                jobStatus = TerminalCraftingJobStatus.PENDING_INPUTS;
                break;
            }
            case INVALID_INPUTS: {
                jobStatus = TerminalCraftingJobStatus.INVALID_INPUTS;
                break;
            }
            case PROCESSING: {
                jobStatus = TerminalCraftingJobStatus.CRAFTING;
                break;
            }
            case FINISHED: {
                jobStatus = TerminalCraftingJobStatus.FINISHED;
            }
        }
        ArrayList auxiliaryPendingOutputs = Lists.newArrayList();
        int recipeOutputAmount = craftingJob.getAmount();
        if (jobStatus == TerminalCraftingJobStatus.CRAFTING) {
            List pendingOutputEntries = craftingInterface.getPendingCraftingJobOutputs(craftingJobId);
            for (Map map : craftingInterface.getPendingCraftingJobOutputs(craftingJobId)) {
                for (List values : map.values()) {
                    for (IPrototypedIngredient value : values) {
                        boolean stacked = false;
                        Iterator it = auxiliaryPendingOutputs.iterator();
                        while (it.hasNext()) {
                            IPrototypedIngredient existingOutput = (IPrototypedIngredient)it.next();
                            IIngredientMatcher matcher = existingOutput.getComponent().getMatcher();
                            if (existingOutput.getComponent() != value.getComponent() || !existingOutput.getCondition().equals(value.getCondition()) || !matcher.matches(existingOutput.getPrototype(), value.getPrototype(), matcher.getExactMatchNoQuantityCondition())) continue;
                            stacked = true;
                            it.remove();
                            auxiliaryPendingOutputs.add(new PrototypedIngredient(existingOutput.getComponent(), matcher.withQuantity(existingOutput.getPrototype(), matcher.getQuantity(existingOutput.getPrototype()) + matcher.getQuantity(value.getPrototype())), existingOutput.getCondition()));
                            break;
                        }
                        if (stacked) continue;
                        auxiliaryPendingOutputs.add(value);
                    }
                }
            }
            recipeOutputAmount -= pendingOutputEntries.size();
        }
        ArrayList pendingOutputs = recipeOutputAmount == 0 ? Lists.newArrayList() : CraftingHelpers.multiplyPrototypedIngredients(recipeOutputs, (long)recipeOutputAmount);
        pendingOutputs.addAll(auxiliaryPendingOutputs);
        ArrayList lastMissingIngredients = Lists.newArrayList();
        if (jobStatus == TerminalCraftingJobStatus.PENDING_INPUTS) {
            for (MissingIngredients value : craftingJob.getLastMissingIngredients().values()) {
                for (MissingIngredients.Element element : value.getElements()) {
                    ArrayList alternatives = Lists.newArrayList();
                    for (MissingIngredients.PrototypedWithRequested alternative : element.getAlternatives()) {
                        IngredientComponent component = alternative.getRequestedPrototype().getComponent();
                        alternatives.add(new PrototypedIngredient(component, component.getMatcher().withQuantity(alternative.getRequestedPrototype().getPrototype(), alternative.getQuantityMissing()), alternative.getRequestedPrototype().getCondition()));
                    }
                    lastMissingIngredients.add(alternatives);
                }
            }
        }
        return new TerminalCraftingPlanStatic<Integer>(craftingJob.getId(), dependencies, pendingOutputs, jobStatus, craftingJob.getAmount(), IntegratedCraftingHelpers.getPrototypesFromIngredients(craftingJob.getIngredientsStorage()), lastMissingIngredients, TerminalCraftingPlanStatic.Label.RUNNING, craftingNetwork.getRunningTicks(craftingJob), craftingJob.getChannel(), TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.uuidToName(craftingJob.getInitiatorUuid()));
    }

    @Nullable
    protected static String uuidToName(@Nullable String uuid) {
        if (uuid != null) {
            try {
                UUID uuidObject = UUID.fromString(uuid);
                return ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(uuidObject).map(GameProfile::getName).orElse(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<ITerminalCraftingPlan<Integer>> getCraftingJobs(INetwork network, int channel) {
        ICraftingNetwork craftingNetwork = (ICraftingNetwork)CraftingHelpers.getCraftingNetwork((INetwork)network).orElse(null);
        if (craftingNetwork == null) {
            return Collections.emptyList();
        }
        Iterable iterable = () -> craftingNetwork.getCraftingJobs(channel);
        CraftingJobDependencyGraph dependencyGraph = craftingNetwork.getCraftingJobDependencyGraph();
        return StreamSupport.stream(iterable.spliterator(), false).filter(job -> job.getDependentCraftingJobs().isEmpty()).map(job -> TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newActiveCraftingJob(craftingNetwork, channel, job, dependencyGraph)).sorted(Comparator.comparingInt(ITerminalCraftingPlan::getId)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ITerminalCraftingPlan<Integer> getCraftingJob(INetwork network, int channel, Integer craftingJobId) {
        ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked((INetwork)network);
        CraftingJob craftingJob = craftingNetwork.getCraftingJob(channel, craftingJobId.intValue());
        if (craftingJob != null) {
            CraftingJobDependencyGraph dependencyGraph = craftingNetwork.getCraftingJobDependencyGraph();
            return TerminalStorageTabIngredientCraftingHandlerCraftingNetwork.newActiveCraftingJob(craftingNetwork, channel, craftingJob, dependencyGraph);
        }
        return null;
    }

    @Override
    public boolean cancelCraftingJob(INetwork network, int channel, Integer craftingJobId) {
        ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked((INetwork)network);
        return craftingNetwork.cancelCraftingJob(channel, craftingJobId.intValue());
    }

    @Override
    public CompoundTag serializeCraftingPlan(ITerminalCraftingPlan<Integer> craftingPlan) {
        CompoundTag tag = TerminalCraftingPlanStatic.serialize((TerminalCraftingPlanStatic)craftingPlan, this);
        if (craftingPlan instanceof TerminalCraftingPlanCraftingJobDependencyGraph) {
            CompoundTag serializedGraph = CraftingJobDependencyGraph.serialize((CraftingJobDependencyGraph)((TerminalCraftingPlanCraftingJobDependencyGraph)craftingPlan).getCraftingJobDependencyGraph());
            tag.m_128365_("craftingJobDependencyGraph", (Tag)serializedGraph);
        }
        return tag;
    }

    @Override
    public ITerminalCraftingPlan<Integer> deserializeCraftingPlan(CompoundTag tag) throws IllegalArgumentException {
        TerminalCraftingPlanStatic<Integer> planStatic = TerminalCraftingPlanStatic.deserialize(tag, this);
        if (tag.m_128441_("craftingJobDependencyGraph")) {
            CraftingJobDependencyGraph craftingJobDependencyGraph = CraftingJobDependencyGraph.deserialize((CompoundTag)tag.m_128469_("craftingJobDependencyGraph"));
            TerminalCraftingPlanCraftingJobDependencyGraph graph = new TerminalCraftingPlanCraftingJobDependencyGraph(planStatic.getId(), planStatic.getDependencies(), planStatic.getOutputs(), planStatic.getStatus(), planStatic.getCraftingQuantity(), planStatic.getStorageIngredients(), planStatic.getLastMissingIngredients(), planStatic.getLabel(), planStatic.getTickDuration(), planStatic.getChannel(), planStatic.getInitiatorName(), craftingJobDependencyGraph);
            if (planStatic.getUnlocalizedLabelOverride() != null) {
                graph.setUnlocalizedLabelOverride(planStatic.getUnlocalizedLabelOverride());
            }
            return graph;
        }
        return planStatic;
    }

    @Override
    public Tag serializeCraftingJobId(Integer id) {
        return IntTag.m_128679_((int)id);
    }

    @Override
    public Integer deserializeCraftingJobId(Tag tag) {
        return ((IntTag)tag).m_7047_();
    }
}

