/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandler;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandlerRegistry;
import org.cyclops.integratedtunnels.core.PlayerHelpers;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.item.ItemDummyPickAxe;

public class ItemStorageBlockWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final boolean writeOnly;
    private final ServerLevel world;
    private final BlockPos pos;
    private final Direction side;
    private final InteractionHand hand;
    private final boolean blockUpdate;
    private final int fortune;
    private final boolean silkTouch;
    private final boolean ignoreReplacable;
    private final boolean breakOnNoDrops;
    private IBlockBreakHandler blockBreakHandler = null;
    private List<ItemStack> cachedDrops = null;
    private boolean extracted = false;

    public ItemStorageBlockWrapper(boolean writeOnly, ServerLevel world, BlockPos pos, Direction side, InteractionHand hand, boolean blockUpdate, int fortune, boolean silkTouch, boolean ignoreReplacable, boolean breakOnNoDrops) {
        this.writeOnly = writeOnly;
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.hand = hand;
        this.blockUpdate = blockUpdate;
        this.fortune = fortune;
        this.silkTouch = silkTouch;
        this.ignoreReplacable = ignoreReplacable;
        this.breakOnNoDrops = breakOnNoDrops;
    }

    protected void sendBlockUpdate() {
        this.world.m_46586_(this.pos, Blocks.f_50016_, this.pos);
    }

    protected IBlockBreakHandler getBlockBreakHandler(BlockState blockState, Level world, BlockPos pos, Player player) {
        return ((IBlockBreakHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockBreakHandlerRegistry.class)).getHandler(blockState, world, pos, player);
    }

    protected void removeBlock(BlockState blockState, Player player) {
        if (this.blockBreakHandler != null) {
            this.blockBreakHandler.breakBlock(blockState, (Level)this.world, this.pos, player);
        } else {
            FluidState fluidState = this.world.m_6425_(this.pos);
            boolean removed = blockState.onDestroyedByPlayer((Level)this.world, this.pos, player, false, fluidState);
            if (removed) {
                blockState.m_60734_().m_6786_((LevelAccessor)this.world, this.pos, blockState);
            }
        }
        if (GeneralConfig.worldInteractionEvents) {
            this.world.m_46796_(2001, this.pos, Block.m_49956_((BlockState)blockState));
        }
        if (this.blockUpdate) {
            this.sendBlockUpdate();
        }
    }

    public static List<ItemStack> getDrops(BlockState state, ServerLevel worldIn, BlockPos pos, @Nullable BlockEntity tileEntityIn) {
        LootParams.Builder lootcontext$builder = new LootParams.Builder(worldIn).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)tileEntityIn);
        return state.m_287290_(lootcontext$builder);
    }

    public boolean isExtracted() {
        return this.extracted;
    }

    @Nullable
    public List<ItemStack> getCachedDrops() {
        return this.cachedDrops;
    }

    protected List<ItemStack> getItemStacks() {
        if (this.writeOnly) {
            boolean isDestReplaceable;
            if (!(this.world.m_46859_(this.pos) || (isDestReplaceable = this.world.m_8055_(this.pos).m_60629_(TunnelHelpers.createBlockItemUseContext((Level)this.world, null, this.pos, this.side, this.hand))) && this.ignoreReplacable)) {
                BlockState blockState = this.world.m_8055_(this.pos);
                return Lists.newArrayList((Object[])new ItemStack[]{BlockHelpers.getItemStackFromBlockState((BlockState)blockState)});
            }
        } else {
            if (this.cachedDrops != null) {
                return this.cachedDrops;
            }
            if (!this.world.m_46859_(this.pos)) {
                BlockState blockState = this.world.m_8055_(this.pos);
                FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
                PlayerHelpers.setPlayerState((Player)player, this.hand, this.pos, 0.0, 0.0, 0.0, this.side, false);
                this.blockBreakHandler = this.getBlockBreakHandler(blockState, (Level)this.world, this.pos, (Player)player);
                if (this.blockBreakHandler != null) {
                    this.cachedDrops = this.blockBreakHandler.getDrops(blockState, (Level)this.world, this.pos, (Player)player);
                } else {
                    BlockEvent.BreakEvent blockBreakEvent = new BlockEvent.BreakEvent((Level)this.world, this.pos, blockState, (Player)player);
                    if (!MinecraftForge.EVENT_BUS.post((Event)blockBreakEvent)) {
                        List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)this.world, (BlockPos)this.pos, (BlockEntity)this.world.m_7702_(this.pos), null, (ItemStack)ItemDummyPickAxe.getItemStack(this.silkTouch, this.fortune));
                        if (drops.size() == 0) {
                            if (this.breakOnNoDrops) {
                                this.removeBlock(blockState, (Player)player);
                            }
                            drops = Lists.newArrayList((Object[])new ItemStack[]{ItemStack.f_41583_});
                        } else {
                            drops = Lists.newArrayList((Iterable)drops);
                            drops.removeIf(ItemStack::m_41619_);
                        }
                        this.cachedDrops = drops;
                        return this.cachedDrops;
                    }
                }
            }
        }
        return Lists.newArrayList((Object[])new ItemStack[]{ItemStack.f_41583_});
    }

    protected IBlockPlaceHandler getBlockPlaceHandler(ItemStack itemStack, Level world, BlockPos pos, Direction side, float hitX, float hitY, float hitZ, Player player) {
        return ((IBlockPlaceHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockPlaceHandlerRegistry.class)).getHandler(itemStack, world, pos, side, hitX, hitY, hitZ, player);
    }

    protected ItemStack setItemStack(ItemStack itemStack, boolean simulate) {
        Item item;
        if (!itemStack.m_41619_() && itemStack.m_41613_() == 1 && (item = itemStack.m_41720_()) instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
            PlayerHelpers.setPlayerState((Player)player, this.hand, this.pos, 0.0, 0.0, 0.0, this.side, false);
            IBlockPlaceHandler blockPlaceHandler = this.getBlockPlaceHandler(itemStack, (Level)this.world, this.pos, this.side.m_122424_(), 0.0f, 0.0f, 0.0f, (Player)player);
            if (blockPlaceHandler != null) {
                blockPlaceHandler.placeBlock(itemStack, (Level)this.world, this.pos, this.side.m_122424_(), 0.0f, 0.0f, 0.0f, (Player)player);
            } else {
                BlockPlaceContext blockItemUseContext = TunnelHelpers.createBlockItemUseContext((Level)this.world, (Player)player, this.pos, this.side.m_122424_(), this.hand);
                BlockState blockState = itemBlock.m_40614_().m_5573_(blockItemUseContext);
                if (blockState != null && (simulate || itemBlock.m_7429_(blockItemUseContext, blockState))) {
                    if (!simulate) {
                        itemBlock.m_7274_(this.pos, (Level)this.world, blockItemUseContext.m_43723_(), itemStack, blockState);
                        itemBlock.m_40614_().m_6402_((Level)this.world, this.pos, blockState, (LivingEntity)player, itemStack);
                        if (GeneralConfig.worldInteractionEvents) {
                            SoundType soundtype = this.world.m_8055_(this.pos).m_60734_().getSoundType(this.world.m_8055_(this.pos), (LevelReader)this.world, this.pos, (Entity)player);
                            this.world.m_5594_((Player)player, this.pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                        }
                        if (this.blockUpdate) {
                            this.sendBlockUpdate();
                        }
                    }
                    return ItemStack.f_41583_;
                }
            }
        }
        return itemStack;
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Lists.newArrayList(this.getItemStacks()).iterator();
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return new FilteredIngredientCollectionIterator((Iterable)((Object)this), this.getComponent().getMatcher(), (Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 1L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.size() > 0 && !(itemStack = itemStacks.get(0)).m_41619_()) {
            return stack;
        }
        if (stack.m_41619_()) {
            return stack;
        }
        ItemStack remaining = stack.m_41777_();
        if (!this.setItemStack(remaining.m_41620_(1), simulate).m_41619_()) {
            return stack;
        }
        return remaining;
    }

    public void postExtract() {
        boolean allEmpty = true;
        for (ItemStack stack : this.getItemStacks()) {
            if (stack.m_41619_()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            BlockState blockState = this.world.m_8055_(this.pos);
            FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
            player.m_6672_(this.hand);
            this.removeBlock(blockState, (Player)player);
        }
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Integer quantityFlag = (Integer)this.getComponent().getPrimaryQuantifier().getMatchCondition();
        Integer subMatchCondition = (Integer)matcher.withoutCondition((Object)matchCondition, (Object)quantityFlag);
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ListIterator<ItemStack> it = itemStacks.listIterator();
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (!matcher.matches((Object)prototype, (Object)itemStack, (Object)subMatchCondition) || matcher.hasCondition((Object)matchCondition, (Object)quantityFlag) && itemStack.m_41613_() < prototype.m_41613_()) continue;
            itemStack = itemStack.m_41777_();
            ItemStack ret = itemStack.m_41620_(Helpers.castSafe((long)prototype.m_41613_()));
            if (!simulate) {
                if (itemStack.m_41619_()) {
                    it.remove();
                } else {
                    it.set(itemStack);
                }
            }
            if (!simulate) {
                this.extracted = true;
                this.postExtract();
            }
            return ret;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = itemStacks.get(0);
        itemStack = itemStack.m_41777_();
        ItemStack ret = itemStack.m_41620_(Helpers.castSafe((long)maxQuantity));
        if (!simulate) {
            if (itemStack.m_41619_()) {
                itemStacks.remove(0);
            } else {
                itemStacks.set(0, itemStack);
            }
        }
        if (!simulate) {
            this.extracted = true;
            this.postExtract();
        }
        return ret;
    }
}

