/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.core.part.PartStateRoundRobin;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.part.aspect.ChanneledTarget;
import org.cyclops.integratedtunnels.part.aspect.IFluidTarget;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;
import org.cyclops.integratedtunnels.part.aspect.ITunnelTransfer;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;
import org.cyclops.integratedtunnels.part.aspect.TunnelConnectionPositionedNetwork;

public class FluidTargetStorage
extends ChanneledTarget<IFluidNetwork, FluidStack>
implements IFluidTarget {
    private final ITunnelConnection connection;
    private final IIngredientComponentStorage<FluidStack, Integer> storage;
    private final IngredientPredicate<FluidStack, Integer> fluidStackMatcher;
    private final PartTarget partTarget;
    private final IAspectProperties properties;

    public FluidTargetStorage(ITunnelTransfer transfer, INetwork network, IIngredientComponentStorage<FluidStack, Integer> storage, IngredientPredicate<FluidStack, Integer> fluidStackMatcher, PartTarget partTarget, IAspectProperties properties, @Nullable PartStateRoundRobin<?> partState) {
        super(network, (IFluidNetwork)network.getCapability(FluidNetworkConfig.CAPABILITY).orElse(null), partState, ((ValueTypeInteger.ValueInteger)properties.getValue(TunnelAspectWriteBuilders.PROP_CHANNEL)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)properties.getValue(TunnelAspectWriteBuilders.PROP_ROUNDROBIN)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)properties.getValue(TunnelAspectWriteBuilders.PROP_CRAFT)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)properties.getValue(TunnelAspectWriteBuilders.PROP_PASSIVE_IO)).getRawValue());
        this.connection = new TunnelConnectionPositionedNetwork(network, this.getChannel(), partTarget.getTarget(), transfer);
        this.storage = storage;
        this.fluidStackMatcher = fluidStackMatcher;
        this.partTarget = partTarget;
        this.properties = properties;
    }

    @Override
    public IIngredientComponentStorage<FluidStack, Integer> getFluidChannel() {
        return ((IFluidNetwork)this.getChanneledNetwork()).getChannel(this.getChannel());
    }

    @Override
    public IIngredientComponentStorageSlotted<FluidStack, Integer> getFluidChannelSlotted() {
        return ((IFluidNetwork)this.getChanneledNetwork()).getChannelSlotted(this.getChannel());
    }

    @Override
    public boolean hasValidTarget() {
        return this.storage != null;
    }

    @Override
    public IIngredientComponentStorage<FluidStack, Integer> getStorage() {
        return this.storage;
    }

    @Override
    public IngredientPredicate<FluidStack, Integer> getFluidStackMatcher() {
        return this.fluidStackMatcher;
    }

    @Override
    public PartTarget getPartTarget() {
        return this.partTarget;
    }

    @Override
    public IAspectProperties getProperties() {
        return this.properties;
    }

    @Override
    public ITunnelConnection getConnection() {
        return this.connection;
    }
}

