/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.restrictions.Restriction;
import jeresources.api.util.BiomeHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeRestriction {
    public static final BiomeRestriction NO_RESTRICTION = new BiomeRestriction();
    public static final BiomeRestriction TAIGA = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48206_);
    public static final BiomeRestriction JUNGLE = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48222_);
    public static final BiomeRestriction PLAINS = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48202_);
    public static final BiomeRestriction SAVANNA = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48157_);
    public static final BiomeRestriction ICE_SPIKES = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48182_);
    public static final BiomeRestriction THE_END = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48210_);
    public static final BiomeRestriction BEACH = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48217_);
    public static final BiomeRestriction FOREST = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48205_);
    public static final BiomeRestriction OCEAN = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48174_);
    public static final BiomeRestriction DESERT = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48203_);
    public static final BiomeRestriction RIVER = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48208_);
    public static final BiomeRestriction SWAMP = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48207_);
    public static final BiomeRestriction MUSHROOM_FIELDS = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48215_);
    public static final BiomeRestriction NETHER_WASTES = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48209_);
    public static final BiomeRestriction DRIPSTONE_CAVES = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_151784_);
    public static final BiomeRestriction BADLANDS = new BiomeRestriction((ResourceKey<Biome>)Biomes.f_48159_);
    private List<Biome> biomes = new ArrayList<Biome>();
    private Restriction.Type restrictionType;

    public BiomeRestriction() {
        this.restrictionType = Restriction.Type.NONE;
    }

    public BiomeRestriction(ResourceKey<Biome> biome) {
        this(BiomeHelper.getBiome(biome));
    }

    public BiomeRestriction(Biome biome) {
        this(Restriction.Type.WHITELIST, biome);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome biome) {
        this(restrictionType, biome, new Biome[0]);
    }

    public BiomeRestriction(Biome biome, Biome ... moreBiomes) {
        this(Restriction.Type.WHITELIST, biome, moreBiomes);
    }

    public BiomeRestriction(Restriction.Type restrictionType, Biome biome, Biome ... moreBiomes) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes.add(biome);
                this.biomes.addAll(Arrays.asList(moreBiomes));
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.remove(biome);
                this.biomes.removeAll(Arrays.asList(moreBiomes));
            }
        }
    }

    public BiomeRestriction(ResourceKey<Biome> biomeCategory, ResourceKey<Biome> ... biomeCategories) {
        this(Restriction.Type.WHITELIST, biomeCategory, biomeCategories);
    }

    public BiomeRestriction(Restriction.Type restrictionType, ResourceKey<Biome> biomeCategory, ResourceKey<Biome> ... biomeCategories) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes = this.getBiomes(biomeCategory, biomeCategories);
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.removeAll(this.getBiomes(biomeCategory, biomeCategories));
            }
        }
    }

    private ArrayList<Biome> getBiomes(ResourceKey<Biome> biomeCategory, ResourceKey<Biome> ... biomeCategories) {
        ArrayList<Object> biomes = new ArrayList<Biome>();
        biomes.addAll(BiomeHelper.getBiomes(biomeCategory));
        for (int i = 1; i < biomeCategories.length; ++i) {
            ArrayList<Biome> newBiomes = new ArrayList<Biome>();
            for (Biome biome : BiomeHelper.getBiomes(biomeCategories[i])) {
                if (!biomes.remove(biome)) continue;
                newBiomes.add(biome);
            }
            biomes = newBiomes;
        }
        return biomes;
    }

    public List<String> toStringList() {
        return this.biomes.stream().filter(biome -> !biome.toString().equals("")).map(biome -> "  " + I18n.m_118938_((String)("biome." + biome.toString().replace(":", ".")), (Object[])new Object[0])).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeRestriction) {
            BiomeRestriction other = (BiomeRestriction)obj;
            return other.biomes.size() == this.biomes.size() && other.biomes.containsAll(this.biomes);
        }
        return false;
    }

    public boolean isMergeAble(BiomeRestriction other) {
        return other.restrictionType == Restriction.Type.NONE || this.restrictionType != Restriction.Type.NONE && !this.biomes.isEmpty() && other.biomes.containsAll(this.biomes);
    }

    public String toString() {
        return "Biomes: " + this.restrictionType + (String)(this.restrictionType != Restriction.Type.NONE ? " - " + this.biomes.size() : "");
    }

    public int hashCode() {
        return this.restrictionType.hashCode() ^ this.biomes.hashCode();
    }
}

