/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.EssenceVesselTileEntity;
import java.util.Set;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;

public class TOPCompat
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("mysticalagriculture", "crops");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
                EssenceVesselTileEntity vessel;
                ItemStack stack;
                BlockEntity tile;
                Block block = state.m_60734_();
                BlockPos pos = data.getPos();
                if (block instanceof ICropProvider) {
                    Holder biome;
                    ResourceLocation id;
                    Set<ResourceLocation> biomes;
                    Block crux;
                    double secondaryChance;
                    ICropProvider provider = (ICropProvider)block;
                    Crop crop = provider.getCrop();
                    Block belowBlock = level.m_8055_(pos.m_7495_()).m_60734_();
                    info.text((Component)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                    if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && (secondaryChance = crop.getSecondaryChance(belowBlock)) > 0.0) {
                        MutableComponent chanceText = Component.m_237113_((String)String.valueOf((int)(secondaryChance * 100.0))).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                        info.text((Component)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                    }
                    if ((crux = crop.getCruxBlock()) != null) {
                        ItemStack stack2 = new ItemStack((ItemLike)crux);
                        info.text((Component)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack2.m_41786_()}).build());
                    }
                    if (!(biomes = crop.getRequiredBiomes()).isEmpty() && !biomes.contains(id = ForgeRegistries.BIOMES.getKey((Object)((Biome)(biome = level.m_204166_(pos)).m_203334_())))) {
                        info.text((Component)ModTooltips.INVALID_BIOME.color(ChatFormatting.RED).build());
                    }
                    if (block instanceof InferiumCropBlock) {
                        int output = 100;
                        if (belowBlock instanceof IEssenceFarmland) {
                            IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                            int tier = farmland.getTier().getValue();
                            output = tier * 50 + 50;
                        }
                        MutableComponent inferiumOutputText = Component.m_237113_((String)String.valueOf(output)).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                        info.text((Component)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
                    }
                }
                if (block instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)block;
                    info.text((Component)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
                }
                if ((tile = level.m_7702_(pos)) instanceof EssenceVesselTileEntity && !(stack = (vessel = (EssenceVesselTileEntity)tile).getInventory().getStackInSlot(0)).m_41619_()) {
                    info.text(String.format("%sx %s", stack.m_41613_(), stack.m_41786_().getString()));
                }
            }
        });
        return null;
    }

    public static void onInterModEnqueue() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPCompat::new);
    }
}

