/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.client.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.oreberriesreplanted.blockentity.VatBlockEntity;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class VatBER
implements BlockEntityRenderer<VatBlockEntity> {
    public VatBER(BlockEntityRendererProvider.Context context) {
    }

    public void render(VatBlockEntity vat, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        FluidStack fluidStack = vat.tank.getFluidInTank(0);
        if (!fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            TextureAtlasSprite fluidTexture = this.getFluidStillSprite(fluid);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.25, 0.5);
            PoseStack.Pose matrixLast = poseStack.m_85850_();
            Matrix4f pose = matrixLast.m_252922_();
            Matrix3f normal = matrixLast.m_252943_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110466_());
            int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = 0.875f;
            float width = 0.875f;
            float height = 0.4375f;
            float minU = fluidTexture.m_118367_(3.0);
            float maxU = fluidTexture.m_118367_(13.0);
            float minV = fluidTexture.m_118393_(3.0);
            float maxV = fluidTexture.m_118393_(13.0);
            float percent = fluidStack.getAmount() >= 200 ? (float)fluidStack.getAmount() / (float)vat.tank.getCapacity() : 0.1f;
            vertexConsumer.m_252986_(pose, -width / 2.0f, -height / 2.0f + percent * height, -width / 2.0f).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(pose, -width / 2.0f, -height / 2.0f + percent * height, width / 2.0f).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(pose, width / 2.0f, -height / 2.0f + percent * height, width / 2.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(pose, width / 2.0f, -height / 2.0f + percent * height, -width / 2.0f).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
            }
            poseStack.m_85849_();
        }
        ItemStack berryStack = vat.handler.getStackInSlot(0);
        int count = berryStack.m_41613_();
        if (!berryStack.m_41619_()) {
            int size = count >= 4 ? count / 4 : 1;
            for (int i = 0; i < size; ++i) {
                Random random = new Random(0L);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 1.0, 0.5);
                poseStack.m_85837_(0.0, -0.9, -0.1875);
                poseStack.m_85837_(0.0, (double)i * 0.03125, 0.125);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85837_((double)i * 0.0125, (double)i * 0.0125, 0.0);
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(i * random.nextInt(360))));
                Minecraft.m_91087_().m_91291_().m_269128_(berryStack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, (Level)level, 0);
                poseStack.m_85849_();
            }
        }
    }

    private TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
    }
}

