/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.registry;

import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import com.mrbysco.oreberriesreplanted.util.FluidHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class LiquidReg {
    private static final ResourceLocation STILL_BERRY = new ResourceLocation("oreberriesreplanted", "block/liquid_berry_still");
    private static final ResourceLocation FLOWING_BERRY = new ResourceLocation("oreberriesreplanted", "block/liquid_berry_flow");
    private final String name;
    private final RegistryObject<FluidType> fluidType;
    private RegistryObject<ForgeFlowingFluid> source;
    private RegistryObject<ForgeFlowingFluid> flowing;
    private RegistryObject<Item> bucket;

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public RegistryObject<FluidType> getFluidType() {
        return this.fluidType;
    }

    @Nonnull
    public RegistryObject<ForgeFlowingFluid> getSource() {
        return this.source;
    }

    @Nonnull
    public RegistryObject<ForgeFlowingFluid> getFlowing() {
        return this.flowing;
    }

    public RegistryObject<Item> getBucket() {
        return this.bucket;
    }

    public static ForgeFlowingFluid.Properties createProperties(Supplier<FluidType> type, Supplier<ForgeFlowingFluid> still, Supplier<ForgeFlowingFluid> flowing, Supplier<Item> bucket) {
        return new ForgeFlowingFluid.Properties(type, still, flowing).bucket(bucket);
    }

    public LiquidReg(String name, final int color, boolean hot) {
        this.name = name;
        this.fluidType = OreBerryRegistry.FLUID_TYPES.register(name, () -> new FluidType(FluidHelper.createTypeProperties().temperature(hot ? 300 : 1000)){

            public double motionScale(Entity entity) {
                return entity.m_9236_().m_6042_().f_63857_() ? 0.007 : 0.0023333333333333335;
            }

            public void setItemMovement(ItemEntity entity) {
                Vec3 vec3 = entity.m_20184_();
                entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return STILL_BERRY;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOWING_BERRY;
                    }

                    public int getTintColor() {
                        return color;
                    }

                    @NotNull
                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        int color = this.getTintColor();
                        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                    }
                });
            }
        });
        this.source = OreBerryRegistry.FLUIDS.register(name, () -> new ForgeFlowingFluid.Source(LiquidReg.createProperties(this.fluidType, this.source, this.flowing, this.bucket)));
        this.flowing = OreBerryRegistry.FLUIDS.register(name + "_flowing", () -> new ForgeFlowingFluid.Flowing(LiquidReg.createProperties(this.fluidType, this.source, this.flowing, this.bucket)));
        this.bucket = OreBerryRegistry.ITEMS.register(name + "_bucket", () -> new BucketItem(this.source, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    }

    public static class Builder {
        private final String name;
        private final int color;
        private boolean hot;

        public Builder(String name, boolean hot, int color) {
            this.name = name;
            this.hot = hot;
            this.color = color;
        }

        public LiquidReg build() {
            return new LiquidReg(this.name, this.color, this.hot);
        }
    }
}

