/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks;

import com.blakebr0.cucumber.helper.ConfigHelper;
import com.blakebr0.pickletweaks.compat.curios.CuriosCompat;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.feature.FeatureBowInfo;
import com.blakebr0.pickletweaks.feature.FeatureRightClickHarvest;
import com.blakebr0.pickletweaks.feature.FeatureToolInfo;
import com.blakebr0.pickletweaks.feature.client.ModelHandler;
import com.blakebr0.pickletweaks.feature.client.handler.ColorHandler;
import com.blakebr0.pickletweaks.feature.client.handler.NightVisionGogglesHandler;
import com.blakebr0.pickletweaks.feature.client.handler.ToggleMagnetInInventoryHandler;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairOverrides;
import com.blakebr0.pickletweaks.init.ModBlocks;
import com.blakebr0.pickletweaks.init.ModCreativeModeTabs;
import com.blakebr0.pickletweaks.init.ModItems;
import com.blakebr0.pickletweaks.init.ModRecipeSerializers;
import com.blakebr0.pickletweaks.lib.ModItemTier;
import com.blakebr0.pickletweaks.network.NetworkHandler;
import com.blakebr0.pickletweaks.tweaks.TweakToolBreaking;
import com.blakebr0.pickletweaks.tweaks.TweakToolUselessifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="pickletweaks")
public final class PickleTweaks {
    public static final String MOD_ID = "pickletweaks";
    public static final String NAME = "Pickle Tweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Pickle Tweaks");

    public PickleTweaks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        ModBlocks.REGISTRY.register(bus);
        ModItems.REGISTRY.register(bus);
        ModCreativeModeTabs.REGISTRY.register(bus);
        ModRecipeSerializers.REGISTRY.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.register((Object)new ColorHandler());
            bus.register((Object)new ModelHandler());
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigs.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigs.COMMON);
        ConfigHelper.load((ForgeConfigSpec)ModConfigs.COMMON, (String)"pickletweaks-common.toml");
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new NightVisionGogglesHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FeatureRightClickHarvest());
        MinecraftForge.EVENT_BUS.register((Object)new TweakToolBreaking());
        MinecraftForge.EVENT_BUS.register((Object)new TweakToolUselessifier());
        if (ModConfigs.isCuriosInstalled()) {
            MinecraftForge.EVENT_BUS.register((Object)new CuriosCompat());
        }
        ModItemTier.onCommonSetup();
        event.enqueueWork(() -> {
            NetworkHandler.onCommonSetup();
            GridRepairOverrides.onCommonSetup();
        });
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ToggleMagnetInInventoryHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FeatureToolInfo());
        MinecraftForge.EVENT_BUS.register((Object)new FeatureBowInfo());
    }

    @SubscribeEvent
    public void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModConfigs.isCuriosInstalled()) {
            CuriosCompat.onInterModEnqueue(event);
        }
    }
}

