/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.codec;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class MapBackedCodec<V extends CodecProvider<? super V>>
implements Codec<V> {
    protected final String name;
    protected final BiMap<ResourceLocation, Codec<? extends V>> registry;
    protected final Supplier<Codec<? extends V>> defaultCodec;

    public MapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry, Supplier<Codec<? extends V>> defaultCodec) {
        this.name = name;
        this.registry = registry;
        this.defaultCodec = defaultCodec;
    }

    public MapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry) {
        this(name, registry, () -> null);
    }

    public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
        Optional type = ops.get(input, "type").resultOrPartial(str -> {});
        Optional<ResourceLocation> key = type.map(t -> (ResourceLocation)((Pair)ResourceLocation.f_135803_.decode(ops, t).resultOrPartial(arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0)).get()).getFirst());
        Codec<? extends V> codec = key.map(arg_0 -> this.registry.get(arg_0)).orElse(this.defaultCodec.get());
        if (codec == null) {
            return DataResult.error(() -> "Failure when parsing a " + this.name + ". Unrecognized type: " + key.map(ResourceLocation::toString).orElse("null"));
        }
        return codec.decode(ops, input);
    }

    public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
        Codec codec = input.getCodec();
        ResourceLocation key = (ResourceLocation)this.registry.inverse().get(codec);
        if (key == null) {
            return DataResult.error(() -> "Attempted to serialize an element of type " + this.name + " with an unregistered codec! Object: " + input);
        }
        Object encodedKey = ResourceLocation.f_135803_.encodeStart(ops, (Object)key).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
        Object encodedObj = codec.encode(input, ops, prefix).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
        return ops.mergeToMap(encodedObj, ops.createString("type"), encodedKey);
    }
}

