/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.EnumSet;
import java.util.Set;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.handlers.CommonInternalAbilities;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="projecte")
public class TickEvents {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).ifPresent(provider -> {
                EnumSet<DyeColor> colorsChanged = EnumSet.noneOf(DyeColor.class);
                for (DyeColor color : TickEvents.getBagColorsPresent(event.player)) {
                    IItemHandler inv = provider.getBag(color);
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        ItemStack current = inv.getStackInSlot(i);
                        if (current.m_41619_()) continue;
                        current.getCapability(PECapabilities.ALCH_BAG_ITEM_CAPABILITY).ifPresent(alchBagItem -> {
                            if (alchBagItem.updateInAlchBag(inv, event.player, current)) {
                                colorsChanged.add(color);
                            }
                        });
                    }
                }
                Player patt1923$temp = event.player;
                if (patt1923$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt1923$temp;
                    for (DyeColor e : colorsChanged) {
                        AbstractContainerMenu patt2089$temp = serverPlayer.f_36096_;
                        if (patt2089$temp instanceof AlchBagContainer) {
                            AlchBagContainer container = (AlchBagContainer)patt2089$temp;
                            ItemStack heldItem = serverPlayer.m_21120_(container.hand);
                            Item patt2232$temp = heldItem.m_41720_();
                            if (patt2232$temp instanceof AlchemicalBag) {
                                AlchemicalBag bag = (AlchemicalBag)patt2232$temp;
                                if (bag.color == e) continue;
                            }
                        }
                        provider.sync(e, serverPlayer);
                    }
                }
            });
            event.player.getCapability(CommonInternalAbilities.CAPABILITY).ifPresent(CommonInternalAbilities::tick);
            if (event.side.isServer()) {
                event.player.getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::tick);
                event.player.getCapability(InternalTimers.CAPABILITY).ifPresent(InternalTimers::tick);
                if (event.player.m_6060_() && TickEvents.shouldPlayerResistFire((ServerPlayer)event.player)) {
                    event.player.m_20095_();
                }
            }
        }
    }

    public static boolean shouldPlayerResistFire(ServerPlayer player) {
        IFireProtector protector;
        Item item;
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IFireProtector) || !(protector = (IFireProtector)item).canProtectAgainstFire(stack, player)) continue;
            return true;
        }
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            ItemStack stack;
            stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IFireProtector) || !(protector = (IFireProtector)item).canProtectAgainstFire(stack, player)) continue;
            return true;
        }
        IItemHandler curios = PlayerHelper.getCurios((Player)player);
        if (curios != null) {
            for (int i = 0; i < curios.getSlots(); ++i) {
                IFireProtector protector2;
                Item item2;
                ItemStack stack = curios.getStackInSlot(i);
                if (stack.m_41619_() || !((item2 = stack.m_41720_()) instanceof IFireProtector) || !(protector2 = (IFireProtector)item2).canProtectAgainstFire(stack, player)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<DyeColor> getBagColorsPresent(Player player) {
        EnumSet<DyeColor> bagsPresent = EnumSet.noneOf(DyeColor.class);
        player.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                Item patt4219$temp;
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_() || !((patt4219$temp = stack.m_41720_()) instanceof AlchemicalBag)) continue;
                AlchemicalBag bag = (AlchemicalBag)patt4219$temp;
                bagsPresent.add(bag.color);
            }
        });
        return bagsPresent;
    }
}

