/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.capability.EmcHolderItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class KleinStar
extends ItemPE
implements IItemEmcHolder,
IBarHelper {
    public final EnumKleinTier tier;

    public KleinStar(Item.Properties props, EnumKleinTier tier) {
        super(props);
        this.tier = tier;
        this.addItemCapability(EmcHolderItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return stack.m_41782_();
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        long starEmc = KleinStar.getEmc(stack);
        if (starEmc == 0L) {
            return 1.0f;
        }
        return (float)(1.0 - (double)starEmc / (double)EMCHelper.getKleinStarMaxEmc(stack));
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && !FMLEnvironment.production) {
            KleinStar.setEmc(stack, EMCHelper.getKleinStarMaxEmc(stack));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public long insertEmc(@NotNull ItemStack stack, long toInsert, IEmcStorage.EmcAction action) {
        if (toInsert < 0L) {
            return this.extractEmc(stack, -toInsert, action);
        }
        long toAdd = Math.min(this.getNeededEmc(stack), toInsert);
        if (action.execute()) {
            ItemPE.addEmcToStack(stack, toAdd);
        }
        return toAdd;
    }

    @Override
    public long extractEmc(@NotNull ItemStack stack, long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(stack, -toExtract, action);
        }
        long storedEmc = this.getStoredEmc(stack);
        long toRemove = Math.min(storedEmc, toExtract);
        if (action.execute()) {
            ItemPE.setEmc(stack, storedEmc - toRemove);
        }
        return toRemove;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getStoredEmc(@NotNull ItemStack stack) {
        return ItemPE.getEmc(stack);
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long getMaximumEmc(@NotNull ItemStack stack) {
        return EMCHelper.getKleinStarMaxEmc(stack);
    }

    public static enum EnumKleinTier {
        EIN("ein"),
        ZWEI("zwei"),
        DREI("drei"),
        VIER("vier"),
        SPHERE("sphere"),
        OMEGA("omega");

        public final String name;

        private EnumKleinTier(String name) {
            this.name = name;
        }
    }
}

