/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Function;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.network.packets.to_client.CooldownResetPKT;
import moze_intel.projecte.network.packets.to_client.SyncBagDataPKT;
import moze_intel.projecte.network.packets.to_client.SyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.SyncFuelMapperPKT;
import moze_intel.projecte.network.packets.to_client.UpdateCondenserLockPKT;
import moze_intel.projecte.network.packets.to_client.UpdateWindowIntPKT;
import moze_intel.projecte.network.packets.to_client.UpdateWindowLongPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeClearPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.UpdateTransmutationTargetsPkt;
import moze_intel.projecte.network.packets.to_server.KeyPressPKT;
import moze_intel.projecte.network.packets.to_server.LeftClickArchangelPKT;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.network.packets.to_server.UpdateGemModePKT;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(4);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)PECore.rl("main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int index;

    public static void register() {
        PacketHandler.registerClientToServer(KeyPressPKT.class, KeyPressPKT::decode);
        PacketHandler.registerClientToServer(LeftClickArchangelPKT.class, LeftClickArchangelPKT::decode);
        PacketHandler.registerClientToServer(SearchUpdatePKT.class, SearchUpdatePKT::decode);
        PacketHandler.registerClientToServer(UpdateGemModePKT.class, UpdateGemModePKT::decode);
        PacketHandler.registerServerToClient(CooldownResetPKT.class, CooldownResetPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeClearPKT.class, KnowledgeClearPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncPKT.class, KnowledgeSyncPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncEmcPKT.class, KnowledgeSyncEmcPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncInputsAndLocksPKT.class, KnowledgeSyncInputsAndLocksPKT::decode);
        PacketHandler.registerServerToClient(KnowledgeSyncChangePKT.class, KnowledgeSyncChangePKT::decode);
        PacketHandler.registerServerToClient(SyncBagDataPKT.class, SyncBagDataPKT::decode);
        PacketHandler.registerServerToClient(SyncEmcPKT.class, SyncEmcPKT::decode);
        PacketHandler.registerServerToClient(SyncFuelMapperPKT.class, SyncFuelMapperPKT::decode);
        PacketHandler.registerServerToClient(UpdateCondenserLockPKT.class, UpdateCondenserLockPKT::decode);
        PacketHandler.registerServerToClient(UpdateTransmutationTargetsPkt.class, UpdateTransmutationTargetsPkt::decode);
        PacketHandler.registerServerToClient(UpdateWindowIntPKT.class, UpdateWindowIntPKT::decode);
        PacketHandler.registerServerToClient(UpdateWindowLongPKT.class, UpdateWindowLongPKT::decode);
    }

    private static <MSG extends IPEPacket> void registerClientToServer(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG extends IPEPacket> void registerServerToClient(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <MSG extends IPEPacket> void registerMessage(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder, NetworkDirection networkDirection) {
        HANDLER.registerMessage(index++, type, IPEPacket::encode, decoder, IPEPacket::handle, Optional.of(networkDirection));
    }

    private static boolean isLocal(ServerPlayer player) {
        return player.f_8924_.m_7779_(player.m_36316_());
    }

    public static <MSG extends IPEPacket> void sendNonLocal(MSG msg, ServerPlayer player) {
        if (!PacketHandler.isLocal(player)) {
            PacketHandler.sendTo(msg, player);
        }
    }

    private static void sendFragmentedEmcPacket(ServerPlayer player, SyncEmcPKT pkt, SyncFuelMapperPKT fuelPkt) {
        if (!PacketHandler.isLocal(player)) {
            PacketHandler.sendTo(pkt, player);
            PacketHandler.sendTo(fuelPkt, player);
        }
    }

    public static void sendFragmentedEmcPacket(ServerPlayer player) {
        PacketHandler.sendFragmentedEmcPacket(player, new SyncEmcPKT(PacketHandler.serializeEmcData()), FuelMapper.getSyncPacket());
    }

    public static void sendFragmentedEmcPacketToAll() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            SyncEmcPKT pkt = new SyncEmcPKT(PacketHandler.serializeEmcData());
            SyncFuelMapperPKT fuelPkt = FuelMapper.getSyncPacket();
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                PacketHandler.sendFragmentedEmcPacket(player, pkt, fuelPkt);
            }
        }
    }

    private static SyncEmcPKT.EmcPKTInfo[] serializeEmcData() {
        SyncEmcPKT.EmcPKTInfo[] data = EMCMappingHandler.createPacketData();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        int index = buf.writerIndex();
        new SyncEmcPKT(data).encode(buf);
        PECore.debugLog("EMC data size: {} bytes", buf.writerIndex() - index);
        buf.release();
        return data;
    }

    public static <MSG extends IPEPacket> void sendToServer(MSG msg) {
        HANDLER.sendToServer(msg);
    }

    public static <MSG extends IPEPacket> void sendTo(MSG msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            HANDLER.send(PacketDistributor.PLAYER.with(() -> player), msg);
        }
    }
}

