/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Predicate;
import moze_intel.projecte.PEPermissions;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.utils.TransmutationEMCFormatter;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class EMCCMD {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"emc").requires((Predicate)PEPermissions.COMMAND_EMC)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires((Predicate)PEPermissions.COMMAND_EMC_ADD)).then(EMCCMD.executeWithParameters(ActionType.ADD)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires((Predicate)PEPermissions.COMMAND_EMC_REMOVE)).then(EMCCMD.executeWithParameters(ActionType.REMOVE)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires((Predicate)PEPermissions.COMMAND_EMC_SET)).then(EMCCMD.executeWithParameters(ActionType.SET)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires((Predicate)PEPermissions.COMMAND_EMC_TEST)).then(EMCCMD.executeWithParameters(ActionType.TEST)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").requires((Predicate)PEPermissions.COMMAND_EMC_GET)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> EMCCMD.handle((CommandContext<CommandSourceStack>)ctx, ActionType.GET))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> executeWithParameters(ActionType actionType) {
        return Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> EMCCMD.handle((CommandContext<CommandSourceStack>)ctx, actionType)));
    }

    private static MutableComponent formatEMC(BigInteger emc) {
        return TextComponentUtil.build(ChatFormatting.GRAY, TransmutationEMCFormatter.formatEMC(emc));
    }

    private static int handle(CommandContext<CommandSourceStack> ctx, ActionType action) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        Optional cap = player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).resolve();
        if (cap.isEmpty()) {
            source.m_81352_((Component)PELang.COMMAND_PROVIDER_FAIL.translate(player.m_5446_()));
            return 0;
        }
        IKnowledgeProvider provider = (IKnowledgeProvider)cap.get();
        if (action == ActionType.GET) {
            source.m_288197_(() -> PELang.COMMAND_EMC_GET_SUCCESS.translate(player.m_5446_(), EMCCMD.formatEMC(provider.getEmc())), true);
            return 1;
        }
        String val = StringArgumentType.getString(ctx, (String)"value");
        BigInteger value = null;
        try {
            value = new BigInteger(val);
            if (value.compareTo(BigInteger.ZERO) < 0) {
                switch (action) {
                    case ADD: 
                    case REMOVE: {
                        action = action == ActionType.ADD ? ActionType.REMOVE : ActionType.ADD;
                        value = value.abs();
                        break;
                    }
                    case SET: 
                    case TEST: {
                        value = null;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == null) {
            source.m_81352_((Component)PELang.COMMAND_EMC_INVALID.translate(val));
            return 0;
        }
        BigInteger newEMC = provider.getEmc();
        switch (action) {
            case ADD: {
                newEMC = newEMC.add(value);
                MutableComponent message = PELang.COMMAND_EMC_ADD_SUCCESS.translate(EMCCMD.formatEMC(value), player.m_5446_(), EMCCMD.formatEMC(newEMC));
                source.m_288197_(() -> EMCCMD.lambda$handle$3((Component)message), true);
                break;
            }
            case REMOVE: {
                newEMC = newEMC.subtract(value);
                if (newEMC.compareTo(BigInteger.ZERO) < 0) {
                    source.m_81352_((Component)PELang.COMMAND_EMC_NEGATIVE.translate(EMCCMD.formatEMC(value), player.m_5446_()));
                    return 0;
                }
                MutableComponent message = PELang.COMMAND_EMC_REMOVE_SUCCESS.translate(EMCCMD.formatEMC(value), player.m_5446_(), EMCCMD.formatEMC(newEMC));
                source.m_288197_(() -> EMCCMD.lambda$handle$4((Component)message), true);
                break;
            }
            case SET: {
                newEMC = value;
                MutableComponent message = PELang.COMMAND_EMC_SET_SUCCESS.translate(player.m_5446_(), EMCCMD.formatEMC(value));
                source.m_288197_(() -> EMCCMD.lambda$handle$5((Component)message), true);
                break;
            }
            case TEST: {
                if (newEMC.compareTo(value) >= 0) {
                    MutableComponent message = PELang.COMMAND_EMC_TEST_SUCCESS.translateColored(ChatFormatting.GREEN, player.m_5446_(), EMCCMD.formatEMC(value));
                    source.m_288197_(() -> EMCCMD.lambda$handle$6((Component)message), true);
                    return 1;
                }
                source.m_81352_((Component)PELang.COMMAND_EMC_TEST_FAIL.translate(player.m_5446_(), EMCCMD.formatEMC(value)));
                return 0;
            }
        }
        provider.setEmc(newEMC);
        provider.syncEmc(player);
        return 1;
    }

    private static /* synthetic */ Component lambda$handle$6(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$handle$5(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$handle$4(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$handle$3(Component message) {
        return message;
    }

    private static enum ActionType {
        ADD,
        REMOVE,
        SET,
        GET,
        TEST;

    }
}

