/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class EMCHelper {
    public static long consumePlayerFuel(Player player, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long minFuel) {
        ItemStack offhand;
        long actualExtracted;
        if (player.m_7500_() || minFuel == 0L) {
            return minFuel;
        }
        IItemHandler curios = PlayerHelper.getCurios(player);
        if (curios != null) {
            for (int i = 0; i < curios.getSlots(); ++i) {
                actualExtracted = EMCHelper.tryExtract(curios.getStackInSlot(i), minFuel);
                if (actualExtracted <= 0L) continue;
                player.f_36096_.m_38946_();
                return actualExtracted;
            }
        }
        if (!(offhand = player.m_21206_()).m_41619_() && (actualExtracted = EMCHelper.tryExtract(offhand, minFuel)) > 0L) {
            player.f_36096_.m_38946_();
            return actualExtracted;
        }
        Optional itemHandlerCap = player.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (itemHandlerCap.isPresent()) {
            IItemHandler inv = (IItemHandler)itemHandlerCap.get();
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
            boolean metRequirement = false;
            long emcConsumed = 0L;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                long actualExtracted2 = EMCHelper.tryExtract(stack, minFuel);
                if (actualExtracted2 > 0L) {
                    player.f_36096_.m_38946_();
                    return actualExtracted2;
                }
                if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
                long emc = EMCHelper.getEmcValue(stack);
                int toRemove = (int)Math.ceil((double)(minFuel - emcConsumed) / (double)emc);
                if (stack.m_41613_() >= toRemove) {
                    map.put(i, toRemove);
                    emcConsumed += emc * (long)toRemove;
                    metRequirement = true;
                    continue;
                }
                map.put(i, stack.m_41613_());
                if ((emcConsumed += emc * (long)stack.m_41613_()) < minFuel) continue;
                metRequirement = true;
            }
            if (metRequirement) {
                for (Map.Entry entry : map.entrySet()) {
                    inv.extractItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue(), false);
                }
                player.f_36096_.m_38946_();
                return emcConsumed;
            }
        }
        return -1L;
    }

    private static long tryExtract(@NotNull ItemStack stack, long minFuel) {
        IItemEmcHolder emcHolder;
        long simulatedExtraction;
        if (stack.m_41619_()) {
            return 0L;
        }
        Optional holderCapability = stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (holderCapability.isPresent() && (simulatedExtraction = (emcHolder = (IItemEmcHolder)holderCapability.get()).extractEmc(stack, minFuel, IEmcStorage.EmcAction.SIMULATE)) == minFuel) {
            return emcHolder.extractEmc(stack, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE);
        }
        return 0L;
    }

    public static boolean doesItemHaveEmc(ItemInfo info) {
        return EMCHelper.getEmcValue(info) > 0L;
    }

    public static boolean doesItemHaveEmc(ItemStack stack) {
        return EMCHelper.getEmcValue(stack) > 0L;
    }

    public static boolean doesItemHaveEmc(ItemLike item) {
        return EMCHelper.getEmcValue(item) > 0L;
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcValue(ItemLike item) {
        return item == null ? 0L : EMCHelper.getEmcValue(ItemInfo.fromItem(item));
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcValue(ItemStack stack) {
        return stack.m_41619_() ? 0L : EMCHelper.getEmcValue(ItemInfo.fromStack(stack));
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcValue(ItemInfo info) {
        return NBTManager.getEmcValue(info);
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcSellValue(ItemStack stack) {
        return stack.m_41619_() ? 0L : EMCHelper.getEmcSellValue(ItemInfo.fromStack(stack));
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcSellValue(ItemInfo info) {
        return EMCHelper.getEmcSellValue(EMCHelper.getEmcValue(info));
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcSellValue(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long originalValue) {
        if (originalValue == 0L) {
            return 0L;
        }
        long emc = (long)Math.floor((double)originalValue * ProjectEConfig.server.difficulty.covalenceLoss.get());
        if (emc < 1L) {
            emc = ProjectEConfig.server.difficulty.covalenceLossRounding.get() ? 1L : 0L;
        }
        return emc;
    }

    public static Component getEmcTextComponent(long emc, int stackSize) {
        String sell;
        String value;
        PELang prefix;
        if (ProjectEConfig.server.difficulty.covalenceLoss.get() == 1.0) {
            String value2;
            PELang prefix2;
            if (stackSize > 1) {
                prefix2 = PELang.EMC_STACK_TOOLTIP;
                value2 = Constants.EMC_FORMATTER.format(BigInteger.valueOf(emc).multiply(BigInteger.valueOf(stackSize)));
            } else {
                prefix2 = PELang.EMC_TOOLTIP;
                value2 = Constants.EMC_FORMATTER.format(emc);
            }
            return prefix2.translateColored(ChatFormatting.YELLOW, ChatFormatting.WHITE, value2);
        }
        long emcSellValue = EMCHelper.getEmcSellValue(emc);
        if (stackSize > 1) {
            prefix = PELang.EMC_STACK_TOOLTIP_WITH_SELL;
            BigInteger bigIntStack = BigInteger.valueOf(stackSize);
            value = Constants.EMC_FORMATTER.format(BigInteger.valueOf(emc).multiply(bigIntStack));
            sell = Constants.EMC_FORMATTER.format(BigInteger.valueOf(emcSellValue).multiply(bigIntStack));
        } else {
            prefix = PELang.EMC_TOOLTIP_WITH_SELL;
            value = Constants.EMC_FORMATTER.format(emc);
            sell = Constants.EMC_FORMATTER.format(emcSellValue);
        }
        return prefix.translateColored(ChatFormatting.YELLOW, ChatFormatting.WHITE, value, ChatFormatting.BLUE, sell);
    }

    public static @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long getKleinStarMaxEmc(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof KleinStar) {
            KleinStar star = (KleinStar)item;
            return Constants.MAX_KLEIN_EMC[star.tier.ordinal()];
        }
        return Constants.MAX_KLEIN_EMC[0];
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEMCPerDurability(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0L;
        }
        if (stack.m_41763_()) {
            ItemStack stackCopy = stack.m_41777_();
            stackCopy.m_41721_(0);
            long emc = (long)Math.ceil((double)EMCHelper.getEmcValue(stackCopy) / (double)stack.m_41776_());
            return Math.max(emc, 1L);
        }
        return 1L;
    }

    public static long removeFractionalEMC(ItemStack stack, double amount) {
        CompoundTag nbt = stack.m_41784_();
        double unprocessedEMC = nbt.m_128459_("UnprocessedEMC");
        long toRemove = (long)(unprocessedEMC += amount);
        nbt.m_128347_("UnprocessedEMC", unprocessedEMC -= (double)toRemove);
        return toRemove;
    }
}

