/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import com.kotori316.scala_lib.ModClassData;
import com.kotori316.scala_lib.ScalaLanguageProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;

public record ScalaLanguageTarget(String className, String modID) implements IModLanguageProvider.IModLanguageLoader,
ModClassData
{
    public <T> T loadMod(IModInfo info, ModFileScanData modFileScanResults, ModuleLayer moduleLayer) {
        try {
            Class<?> scalaContainer = Class.forName("com.kotori316.scala_lib.ScalaModContainer", true, Thread.currentThread().getContextClassLoader());
            ScalaLanguageProvider.LOGGER.debug(Logging.LOADING, "Loading ScalaModContainer from classloader {} - got {}", (Object)Thread.currentThread().getContextClassLoader(), (Object)scalaContainer.getClassLoader());
            Constructor<?> constructor = scalaContainer.getConstructor(IModInfo.class, String.class, ModFileScanData.class, ModuleLayer.class);
            return (T)constructor.newInstance(info, this.className, modFileScanResults, moduleLayer);
        }
        catch (InvocationTargetException invocationTargetException) {
            ScalaLanguageProvider.LOGGER.fatal(Logging.LOADING, "Failed to build mod", (Throwable)invocationTargetException);
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ModLoadingException) {
                ModLoadingException modLoadingException = (ModLoadingException)throwable;
                throw modLoadingException;
            }
            throw ScalaLanguageTarget.createMLE(info, invocationTargetException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            ScalaLanguageProvider.LOGGER.fatal(Logging.LOADING, "Unable to load ScalaModContainer", (Throwable)reflectiveOperationException);
            throw ScalaLanguageTarget.createMLE(info, reflectiveOperationException);
        }
    }

    private static ModLoadingException createMLE(IModInfo info, ReflectiveOperationException e) {
        return new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.ModLoading.FailedToLoadModClass".toLowerCase(Locale.ROOT), (Throwable)e, new Object[0]);
    }
}

