/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.base.list.PlayerListScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;

public class InvitablePlayersScreen
extends PlayerListScreen
implements LoadingResultHandler {
    private static final Component INVITE = ComponentBuilder.text("invite", new Object[0]);
    private final Team team;
    private final BaseScreen prev;
    private Button inviteButton;
    private Checkbox selectAll;
    private int selectedAmount = 0;

    public InvitablePlayersScreen(Team team, BaseScreen prev) {
        super((Component)Component.m_237113_((String)team.getName()), InvitablePlayersScreen.getInvitablePlayers(team), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
        this.team = team;
        this.prev = prev;
    }

    @Override
    protected void m_7856_() {
        this.inviteButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)INVITE, button -> {
            Set inviteIds = this.getSelectedValues().stream().map(GameProfile::getId).collect(Collectors.toSet());
            Minecraft.m_91087_().pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, (Component)ComponentBuilder.text("you_sure_invite", inviteIds.size()), () -> {
                SkyGUIs.getNetwork().handleInvitePlayers(this.team.getName(), inviteIds);
                Minecraft.m_91087_().m_91152_((Screen)new InvitablePlayersScreen(this.team, this.prev));
            }, () -> Minecraft.m_91087_().m_91152_((Screen)this)));
        }).m_252987_(this.x(10), this.y(200), 40, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)).m_252987_(this.x(57), this.y(200), 115, 20).m_253136_());
        this.selectAll = (Checkbox)this.m_142416_((GuiEventListener)new SizeableCheckbox(this.x(9), this.y(32), 14, false, this.allSelected() ? UNSELECT_ALL : SELECT_ALL){

            public void m_5691_() {
                super.m_5691_();
                if (this.f_93822_) {
                    InvitablePlayersScreen.this.selectAll();
                } else {
                    InvitablePlayersScreen.this.unselectAll();
                }
            }
        });
        super.m_7856_();
        this.updateButtons();
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
    }

    @Override
    public void render_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, (Component)ComponentBuilder.text("selected_amount", this.selectedAmount), this.x(28), this.y(35), Color.DARK_GRAY.getRGB(), false);
    }

    public void updateButtons() {
        Set selectedIds = this.getSelectedValues().stream().map(GameProfile::getId).collect(Collectors.toSet());
        this.inviteButton.f_93623_ = !selectedIds.isEmpty();
        this.selectAll.f_93822_ = this.allSelected();
        this.selectedAmount = selectedIds.size();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean ret = super.m_6375_(mouseX, mouseY, button);
        this.updateButtons();
        return ret;
    }

    private static Set<UUID> getInvitablePlayers(Team team) {
        HashSet ids = Sets.newHashSet();
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null) {
            return ids;
        }
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        for (UUID id : player.f_108617_.m_105143_()) {
            if (data.hasPlayerTeam(id) || data.hasInviteFrom(team, id)) continue;
            ids.add(id);
        }
        return ids;
    }
}

