/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CreateCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(source -> PermissionsConfig.createOwnTeam)).executes(context -> CreateCommand.create((CommandSourceStack)context.getSource(), null, Collections.emptyList()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> CreateCommand.create((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), Collections.emptyList()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).requires(commandSource -> commandSource.m_6761_(2))).executes(context -> CreateCommand.create((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), EntityArgument.m_91477_((CommandContext)context, (String)"players")))));
    }

    private static int create(CommandSourceStack source, String name, Collection<ServerPlayer> players) throws CommandSyntaxException {
        Entity entity;
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (name == null) {
            Random rand = new Random();
            while (data.teamExists(name = NameGenerator.randomName(rand))) {
            }
        }
        if (SkyblockHooks.onCreateTeam(name)) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.create_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (players.isEmpty() && source.m_81373_() instanceof ServerPlayer && data.hasPlayerTeam((Player)((ServerPlayer)source.m_81373_()))) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Team team = data.createTeam(name);
        String finalName = name;
        if (team == null) {
            source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.error.team_already_exist", (Object[])new Object[]{finalName}).m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (players.isEmpty() && (entity = source.m_81373_()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            data.addPlayerToTeam(team, (Player)player2);
            WorldUtil.teleportToIsland(player2, team);
        } else {
            players.forEach(player -> {
                if (data.getTeamFromPlayer((Player)player) != null) {
                    source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.error.player_has_team", (Object[])new Object[]{player.m_5446_().getString()}).m_130940_(ChatFormatting.RED), false);
                } else {
                    data.addPlayerToTeam(team, (Player)player);
                    WorldUtil.teleportToIsland(player, team);
                }
            });
        }
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.create_team", (Object[])new Object[]{finalName}).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }
}

