/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.moddingx.libx.command.EnumArgument2;
import org.moddingx.libx.config.ConfigManager;

public class SpawnsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"spawns").executes(context -> SpawnsCommand.showSpawns((CommandSourceStack)context.getSource(), Mode.NORMAL))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", (ArgumentType)EnumArgument2.enumArgument(Mode.class)).requires(source -> source.m_6761_(2))).executes(context -> SpawnsCommand.showSpawns((CommandSourceStack)context.getSource(), (Mode)((Object)((Object)context.getArgument("mode", Mode.class))))));
    }

    private static int showSpawns(CommandSourceStack source, Mode mode) throws CommandSyntaxException {
        Set<TemplatesConfig.Spawn> spawns;
        ServerPlayer player;
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (mode.isExporting()) {
            Team team = null;
            if (source.m_81373_() instanceof ServerPlayer) {
                team = data.getTeamFromPlayer((Player)source.m_81373_());
            }
            if (team == null) {
                team = data.getSpawn();
            }
            if (mode == Mode.EXPORT) {
                try {
                    Files.createDirectories(SkyPaths.MOD_EXPORTS, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"skyblockbuilder.command.error.creating_path", (Object[])new Object[]{SkyPaths.MOD_EXPORTS})).create();
                }
                Path filePath = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, "spawns", "json");
                JsonObject json = TemplateUtil.possibleSpawnsAsJson(team);
                Path file = SkyPaths.MOD_EXPORTS.resolve(filePath.getFileName());
                try {
                    Files.writeString(file, (CharSequence)SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"skyblockbuilder.command.error.creating_file", (Object[])new Object[]{file})).create();
                }
                source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.export_spawns", (Object[])new Object[]{filePath}).m_130940_(ChatFormatting.GOLD), true);
            } else if (mode == Mode.EXPORT_TO_CONFIG) {
                JsonObject json = TemplateUtil.possibleSpawnsAsJson(team);
                Path configFile = SkyPaths.MOD_CONFIG.resolve("templates.json5");
                try {
                    JsonObject config = (JsonObject)SkyblockBuilder.PRETTY_GSON.fromJson(Files.readString(configFile), JsonObject.class);
                    if (!config.has("spawns")) {
                        config.add("spawns", (JsonElement)new JsonObject());
                    }
                    JsonObject spawns2 = config.get("spawns").getAsJsonObject();
                    Calendar calendar = Calendar.getInstance();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    String formattedDate = dateFormat.format(calendar.getTime());
                    spawns2.add("exported_at_" + formattedDate, (JsonElement)json);
                    config.add("spawns", (JsonElement)spawns2);
                    Files.writeString(configFile, (CharSequence)SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)config), new OpenOption[0]);
                    ConfigManager.reloadConfig(TemplatesConfig.class);
                    if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                        ConfigManager.forceResync(null);
                    }
                    source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.export_spawns_to_config", (Object[])new Object[]{formattedDate}).m_130940_(ChatFormatting.GOLD), true);
                }
                catch (IOException e) {
                    throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"skyblockbuilder.command.error.overwrite_config", (Object[])new Object[]{configFile.getFileName()})).create();
                }
            }
            return 1;
        }
        Team team = data.getSpawn();
        Entity configFile = source.m_81373_();
        if (configFile instanceof ServerPlayer && (team = data.getTeamFromPlayer((Player)(player = (ServerPlayer)configFile))) == null) {
            team = data.getSpawn();
        }
        boolean showDefaultSpawns = team.isSpawn() && mode == Mode.NORMAL;
        Set<TemplatesConfig.Spawn> set = spawns = showDefaultSpawns ? team.getDefaultPossibleSpawns() : team.getPossibleSpawns();
        if (!spawns.isEmpty()) {
            source.m_243053_((Component)Component.m_237110_((String)"skyblockbuilder.command.info.show_team_spawns", (Object[])new Object[]{team.getName()}).m_130940_(ChatFormatting.GOLD));
        }
        for (TemplatesConfig.Spawn spawn : spawns) {
            BlockPos pos = spawn.pos();
            source.m_243053_((Component)Component.m_237113_((String)" - ").m_7220_(RandomUtility.getFormattedPos(pos)));
            Entity entity = source.m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity;
                level.m_8624_(player2, (ParticleOptions)ParticleTypes.f_123748_, true, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.1, 0.1, 0.1, 10.0);
                continue;
            }
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.1, 0.1, 0.1, 10.0);
        }
        return 1;
    }

    public static enum Mode {
        NORMAL,
        DEBUG,
        EXPORT,
        EXPORT_TO_CONFIG;


        public boolean isExporting() {
            return this == EXPORT || this == EXPORT_TO_CONFIG;
        }
    }
}

