/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat.heracles;

import de.melanx.skyblockbuilder.compat.heracles.HeraclesCompat;
import de.melanx.skyblockbuilder.compat.heracles.SpreadLocationTask;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.events.SkyblockOpManageEvent;
import earth.terrarium.heracles.common.handlers.progress.QuestProgressHandler;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HeraclesEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLeavesTeam(SkyblockManageTeamEvent.Leave event) {
        ServerPlayer player = event.getPlayer();
        HeraclesCompat.resetQuestProgress(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRemovedFromTeam(SkyblockOpManageEvent.RemoveFromTeam event) {
        HeraclesCompat.resetQuestProgress(event.getPlayers());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTeamDeletion(SkyblockOpManageEvent.DeleteTeam event) {
        for (UUID player : event.getTeam().getPlayers()) {
            HeraclesCompat.resetQuestProgress(event.getSource().m_81377_(), player);
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.getServer().m_129921_() % 20 != 0) {
            return;
        }
        MinecraftServer server = event.getServer();
        server.m_6846_().m_11314_().forEach(player -> QuestProgressHandler.getProgress((MinecraftServer)server, (UUID)player.m_20148_()).testAndProgressTaskType(player, player, SpreadLocationTask.TYPE));
    }
}

