/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat.heracles;

import com.teamresourceful.resourcefullib.client.scissor.ScissorBoxStack;
import de.melanx.skyblockbuilder.compat.heracles.SpreadLocationTask;
import de.melanx.skyblockbuilder.compat.heracles.SpreadPredicate;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import earth.terrarium.heracles.api.client.DisplayWidget;
import earth.terrarium.heracles.api.client.WidgetUtils;
import earth.terrarium.heracles.api.client.theme.QuestScreenTheme;
import earth.terrarium.heracles.api.tasks.QuestTask;
import earth.terrarium.heracles.api.tasks.client.display.TaskTitleFormatter;
import earth.terrarium.heracles.common.handlers.progress.TaskProgress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.NumericTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class SpreadTaskWidget
implements DisplayWidget {
    private final SpreadLocationTask task;
    private final TaskProgress<NumericTag> progress;
    private final Team team;

    public SpreadTaskWidget(SpreadLocationTask task, TaskProgress<NumericTag> progress) {
        this.task = task;
        this.progress = progress;
        this.team = SkyblockSavedData.get((Level)Minecraft.m_91087_().f_91073_).getTeamFromPlayer((Player)Minecraft.m_91087_().f_91074_);
    }

    public void render(GuiGraphics graphics, ScissorBoxStack scissor, int x, int y, int width, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        WidgetUtils.drawBackground((GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)this.getHeight(width));
        int iconSize = 32;
        this.task.icon().renderOrStack(Items.f_42573_.m_7968_(), graphics, scissor, x + 5, y + this.getHeight(width) / 2 - iconSize / 2, iconSize);
        graphics.m_280614_(font, this.task.titleOr(TaskTitleFormatter.create((QuestTask)this.task)), x + iconSize + 16, y + 6, QuestScreenTheme.getTaskTitle(), false);
        int baseX = x + iconSize + 16;
        Objects.requireNonNull(font);
        int baseY = y + 8 + 9;
        if (this.team == null || this.team.getPlacedSpreads().isEmpty()) {
            graphics.m_280614_(font, (Component)Component.m_237115_((String)"setting.skyblockbuilder.spread_location.no_valid_spreads"), baseX, baseY, QuestScreenTheme.getTaskDescription(), false);
        } else if (this.task.predicate() == SpreadPredicate.ALWAYS_TRUE) {
            graphics.m_280614_(font, (Component)Component.m_237115_((String)"setting.skyblockbuilder.spread_location.no_spreads_defined"), baseX, baseY, QuestScreenTheme.getTaskDescription(), false);
        } else {
            List<String> spreads = this.task.predicate().getSpreads();
            Map<String, Set<Team.PlacedSpread>> teamSpreads = this.team.getPlacedSpreads();
            List<String> validSpreads = spreads.stream().filter(teamSpreads::containsKey).toList();
            if (!validSpreads.isEmpty()) {
                int i = 2;
                graphics.m_280614_(font, (Component)Component.m_237115_((String)"setting.skyblockbuilder.spread_location.visit_spreads"), baseX, baseY, QuestScreenTheme.getTaskDescription(), false);
                for (String spread : spreads) {
                    MutableComponent mutableComponent = Component.m_237113_((String)("  - " + spread));
                    Objects.requireNonNull(font);
                    graphics.m_280614_(font, (Component)mutableComponent, baseX, y + 8 + (9 + 1) * i++, QuestScreenTheme.getTaskDescription(), false);
                }
            } else {
                graphics.m_280614_(font, (Component)Component.m_237115_((String)"setting.skyblockbuilder.spread_location.no_valid_spreads"), baseX, baseY, QuestScreenTheme.getTaskDescription(), false);
            }
        }
        WidgetUtils.drawProgressText((GuiGraphics)graphics, (int)x, (int)y, (int)width, (QuestTask)this.task, this.progress);
        int height = this.getHeight(width);
        Objects.requireNonNull(font);
        WidgetUtils.drawProgressBar((GuiGraphics)graphics, (int)(x + iconSize + 16), (int)(y + height - 9 - 5), (int)(x + width - 5), (int)(y + height - 6), (QuestTask)this.task, this.progress);
    }

    public int getHeight(int width) {
        if (this.team == null || this.team.getPlacedSpreads().isEmpty() || this.task.predicate() == SpreadPredicate.ALWAYS_TRUE) {
            return 42;
        }
        int n = this.task.predicate().getSpreads().size();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return n * (9 + 1) + 42;
    }
}

