/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonArray;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.gui.EditorHelper;
import org.moddingx.libx.impl.config.mappers.SimpleValueMappers;
import org.moddingx.libx.screen.Panel;

public class BlockPosMapper
implements ValueMapper<BlockPos, JsonArray> {
    public static BlockPos fromJsonArray(JsonArray json) {
        if (json.size() != 3) {
            throw new IllegalStateException("Invalid BlockPos: " + json);
        }
        return new BlockPos(json.get(0).getAsInt(), json.get(1).getAsInt(), json.get(2).getAsInt());
    }

    public static JsonArray toJsonArray(BlockPos value) {
        JsonArray array = new JsonArray();
        array.add((Number)value.m_123341_());
        array.add((Number)value.m_123342_());
        array.add((Number)value.m_123343_());
        return array;
    }

    public BlockPos fromJson(JsonArray json) {
        return BlockPosMapper.fromJsonArray(json);
    }

    public JsonArray toJson(BlockPos value) {
        return BlockPosMapper.toJsonArray(value);
    }

    public Class<BlockPos> type() {
        return BlockPos.class;
    }

    public Class<JsonArray> element() {
        return JsonArray.class;
    }

    public ConfigEditor<BlockPos> createEditor(ValidatorInfo<?> validator) {
        return new BlockPosEditor();
    }

    private static class BlockPosEditor
    implements ConfigEditor<BlockPos> {
        private BlockPosEditor() {
        }

        public BlockPos defaultValue() {
            return BlockPos.f_121853_;
        }

        public AbstractWidget createWidget(Screen screen, BlockPos initialValue, WidgetProperties<BlockPos> properties) {
            return new BlockPosWidget(screen, initialValue, null, null, null, properties);
        }

        public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<BlockPos> properties) {
            if (old instanceof BlockPosWidget) {
                return new BlockPosWidget(screen, ((BlockPosWidget)old).getPos(), ((BlockPosWidget)old).xWidget, ((BlockPosWidget)old).yWidget, ((BlockPosWidget)old).zWidget, properties);
            }
            return this.createWidget(screen, this.defaultValue(), properties);
        }

        private static class BlockPosWidget
        extends Panel {
            public final Font font;
            public final AbstractWidget xWidget;
            public final AbstractWidget yWidget;
            public final AbstractWidget zWidget;
            private int posX;
            private int posY;
            private int posZ;

            public BlockPosWidget(Screen screen, BlockPos value, @Nullable AbstractWidget xWidget, @Nullable AbstractWidget yWidget, @Nullable AbstractWidget zWidget, WidgetProperties<BlockPos> properties) {
                super(properties.x(), properties.y(), properties.width(), properties.height());
                this.font = Minecraft.m_91087_().f_91062_;
                this.posX = value.m_123341_();
                this.posY = value.m_123342_();
                this.posZ = value.m_123343_();
                WidgetProperties xProperties = new WidgetProperties(this.font.m_92895_("X") + 3, 0, 50, properties.height(), x -> {
                    this.posX = x;
                    properties.inputChanged().accept(new BlockPos(this.posX, this.posY, this.posZ));
                });
                WidgetProperties yProperties = new WidgetProperties(this.font.m_92895_("XY") + 60, 0, 50, properties.height(), y -> {
                    this.posY = y;
                    properties.inputChanged().accept(new BlockPos(this.posX, this.posY, this.posZ));
                });
                WidgetProperties zProperties = new WidgetProperties(this.font.m_92895_("XYZ") + 120, 0, 50, properties.height(), z -> {
                    this.posZ = z;
                    properties.inputChanged().accept(new BlockPos(this.posX, this.posY, this.posZ));
                });
                ConfigEditor editor = SimpleValueMappers.INTEGER.createEditor(ValidatorInfo.empty());
                this.xWidget = (AbstractWidget)this.addRenderableWidget((GuiEventListener)EditorHelper.create((Screen)screen, (ConfigEditor)editor, (Object)this.posX, (AbstractWidget)xWidget, (WidgetProperties)xProperties));
                this.yWidget = (AbstractWidget)this.addRenderableWidget((GuiEventListener)EditorHelper.create((Screen)screen, (ConfigEditor)editor, (Object)this.posY, (AbstractWidget)yWidget, (WidgetProperties)yProperties));
                this.zWidget = (AbstractWidget)this.addRenderableWidget((GuiEventListener)EditorHelper.create((Screen)screen, (ConfigEditor)editor, (Object)this.posZ, (AbstractWidget)zWidget, (WidgetProperties)zProperties));
            }

            private BlockPos getPos() {
                return new BlockPos(this.posX, this.posY, this.posZ);
            }

            public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.m_280488_(this.font, "X", this.m_252754_(), this.m_252907_() + 6, Color.GRAY.getRGB());
                guiGraphics.m_280488_(this.font, "Y", this.m_252754_() + 63, this.m_252907_() + 6, Color.GRAY.getRGB());
                guiGraphics.m_280488_(this.font, "Z", this.m_252754_() + 128, this.m_252907_() + 6, Color.GRAY.getRGB());
                super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
    }
}

