/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration;

import com.mojang.logging.LogUtils;
import edivad.edivadlib.setup.UpdateChecker;
import edivad.solargeneration.client.screen.SolarPanelScreen;
import edivad.solargeneration.datagen.AdvancementProvider;
import edivad.solargeneration.datagen.Lang;
import edivad.solargeneration.datagen.LootTables;
import edivad.solargeneration.datagen.Recipes;
import edivad.solargeneration.datagen.SolarPanelBlockTagsProvider;
import edivad.solargeneration.datagen.SolarPanelItemTagsProvider;
import edivad.solargeneration.network.PacketHandler;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.setup.SolarGenerationCreativeModeTabs;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="solargeneration")
public class SolarGeneration {
    public static final String ID = "solargeneration";
    public static final String MODNAME = "SolarGeneration";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SolarGeneration() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleClientSetup);
        modEventBus.addListener(this::handleGatherData);
        Registration.init(modEventBus);
        SolarGenerationCreativeModeTabs.register(modEventBus);
        PacketHandler.init();
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new UpdateChecker(ID));
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            MenuType menu = (MenuType)Registration.SOLAR_PANEL_CONTAINER.get((Object)level).get();
            MenuScreens.m_96206_((MenuType)menu, SolarPanelScreen::new);
        }
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), LootTables::create);
        SolarPanelBlockTagsProvider blockTags = new SolarPanelBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        CompletableFuture blockTagsLookup = blockTags.m_274426_();
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new SolarPanelItemTagsProvider(packOutput, lookupProvider, blockTagsLookup, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new Lang(packOutput));
    }
}

