/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blocks;

import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape BOX = SolarPanelBlock.createShape();
    private static final BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");
    private final SolarPanelLevel solarPanelLevel;

    public SolarPanelBlock(SolarPanelLevel solarPanelLevel, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.solarPanelLevel = solarPanelLevel;
    }

    private static VoxelShape createShape() {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(SolarPanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        shapes.add(SolarPanelBlock.m_49796_((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0));
        shapes.add(SolarPanelBlock.m_49796_((double)6.0, (double)1.0, (double)9.0, (double)7.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanelBlock.m_49796_((double)9.0, (double)1.0, (double)9.0, (double)10.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanelBlock.m_49796_((double)9.0, (double)1.0, (double)6.0, (double)10.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanelBlock.m_49796_((double)6.0, (double)1.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanelBlock.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        VoxelShape combinedShape = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return combinedShape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        level.m_141902_(pos, (BlockEntityType)Registration.SOLAR_PANEL_TILE.get((Object)this.solarPanelLevel).get()).ifPresent(blockEntity -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity, (BlockPos)pos));
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, level, pos, player, false, fluid);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        level.m_7471_(pos, false);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SolarPanelBlockEntity(this.solarPanelLevel, blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.m_5776_() ? null : BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)Registration.SOLAR_PANEL_TILE.get((Object)this.solarPanelLevel).get()), SolarPanelBlockEntity::serverTick);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            CompoundTag tag = itemStack.m_41783_();
            if (blockEntity != null && tag != null) {
                blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(cap -> ((SolarPanelBattery)((Object)cap)).setEnergy(tag.m_128451_("energy")));
            }
        }
        super.m_6402_(level, pos, state, placer, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            int energy = tag.m_128451_("energy");
            tooltip.add((Component)Tooltip.showInfoCtrl(energy));
        }
        tooltip.addAll(Tooltip.showInfoShift(this.solarPanelLevel));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(levelAccessor, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(blockGetter, pos, state, fluidIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

