/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tools;

import java.util.Locale;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;

public enum SolarPanelLevel {
    LEADSTONE,
    HARDENED,
    REDSTONE,
    SIGNALUM,
    RESONANT,
    ADVANCED,
    ULTIMATE;


    public String getSolarPanelName() {
        return "solar_panel_" + this.getCorrectName();
    }

    public String getSolarHelmetName() {
        return "solar_helmet_" + this.getCorrectName();
    }

    public String getSolarCoreName() {
        return "solar_core_" + this.getCorrectName();
    }

    public String getArmorTexture() {
        return "solargeneration:textures/model/armor/solar_helmet_" + this.getCorrectName() + ".png";
    }

    public ArmorMaterial getArmorMaterial() {
        return switch (this.ordinal()) {
            case 0, 1 -> ArmorMaterials.IRON;
            case 2, 3, 4, 5 -> ArmorMaterials.DIAMOND;
            case 6 -> ArmorMaterials.NETHERITE;
            default -> throw new RuntimeException("Solar panel tier not yet implemented!");
        };
    }

    public int getEnergyGeneration() {
        return (int)Math.pow(8.0, this.ordinal());
    }

    public int getMaxTransfer() {
        return this.getEnergyGeneration() * 2;
    }

    public int getCapacity() {
        return this.getEnergyGeneration() * 1000;
    }

    private String getCorrectName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

