/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.command;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.export.ClientExportHelper;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="sfm")
public class SFMCommand {
    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"sfm");
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"bust_cable_network_cache").requires(source -> source.m_6761_(0))).executes(ctx -> {
            SFM.LOGGER.info("Busting cable networks - slash command used by {}", (Object)((CommandSourceStack)ctx.getSource()).m_81368_());
            CableNetworkManager.clear();
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"show_bad_cable_cache_entries").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)event.getBuildContext())).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            CableNetworkManager.getBadCableCachePositions((Level)level).forEach(pos -> {
                BlockInput block = BlockStateArgument.m_116123_((CommandContext)ctx, (String)"block");
                block.m_114670_(level, pos, 3);
            });
            return 1;
        })));
        if (FMLEnvironment.dist.isClient()) {
            command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export_info").requires(__ -> true)).then(Commands.m_82129_((String)"includeHidden", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                boolean includeHidden = BoolArgumentType.getBool((CommandContext)ctx, (String)"includeHidden");
                SFM.LOGGER.info("Exporting info, includeHidden={} - slash command used by {}", (Object)includeHidden, (Object)((CommandSourceStack)ctx.getSource()).m_81368_());
                assert (Minecraft.m_91087_().f_91074_ != null);
                new Thread(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"Beginning item export"));
                        ClientExportHelper.dumpItems((Player)((CommandSourceStack)ctx.getSource()).m_230896_());
                        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"Beginning JEI export"));
                        ClientExportHelper.dumpJei((Player)((CommandSourceStack)ctx.getSource()).m_230896_(), includeHidden);
                        long end = System.currentTimeMillis();
                        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("Exported data in " + (end - start) + "ms")).m_130940_(ChatFormatting.GREEN));
                    }
                    catch (Exception e) {
                        SFM.LOGGER.error("Failed to export item data", (Throwable)e);
                    }
                }).start();
                return 1;
            })));
        }
        event.getDispatcher().register(command);
    }
}

