/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.compat;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.GasResourceType;
import ca.teamdman.sfm.common.resourcetype.InfuseResourceType;
import ca.teamdman.sfm.common.resourcetype.PigmentResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.resourcetype.SlurryResourceType;
import ca.teamdman.sfml.ast.DirectionQualifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.DeferredRegister;

public class SFMMekanismCompat {
    public static Optional<ResourceType<?, ?, ?>> getResourceType(TransmissionType trans) {
        return switch (trans) {
            case TransmissionType.ITEM -> Optional.of((ResourceType)SFMResourceTypes.ITEM.get());
            case TransmissionType.FLUID -> Optional.of((ResourceType)SFMResourceTypes.FLUID.get());
            case TransmissionType.GAS -> Optional.of((ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "gas")));
            case TransmissionType.INFUSION -> Optional.of((ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "infusion")));
            case TransmissionType.PIGMENT -> Optional.of((ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "pigment")));
            case TransmissionType.SLURRY -> Optional.of((ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", "slurry")));
            default -> Optional.empty();
        };
    }

    public static String gatherInspectionResults(BlockEntity blockEntity) {
        if (!(blockEntity instanceof ISideConfiguration)) {
            return "";
        }
        ISideConfiguration sideConfiguration = (ISideConfiguration)blockEntity;
        StringBuilder sb = new StringBuilder();
        sb.append("-- Mekanism stuff\n");
        TileComponentConfig config = sideConfiguration.getConfig();
        for (TransmissionType type : TransmissionType.values()) {
            SFMMekanismCompat.getResourceType(type).flatMap(resourceType -> SFMResourceTypes.DEFERRED_TYPES.get().getResourceKey(resourceType)).ifPresent(resourceTypeKey -> {
                ConfigInfo info = config.getConfig(type);
                if (info != null) {
                    Set outputSides = info.getSides(DataType::canOutput);
                    if (!outputSides.isEmpty()) {
                        sb.append("-- ").append(LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_MACHINE_OUTPUTS.getString()).append("\n");
                        sb.append("INPUT ").append(resourceTypeKey.m_135782_()).append(":: FROM target ");
                        sb.append(outputSides.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", ")));
                        sb.append(" SIDE\n");
                    }
                    HashSet<Direction> inputSides = new HashSet<Direction>();
                    for (RelativeSide side : RelativeSide.values()) {
                        DataType dataType = info.getDataType(side);
                        if (dataType != DataType.INPUT && dataType != DataType.INPUT_1 && dataType != DataType.INPUT_2 && dataType != DataType.INPUT_OUTPUT) continue;
                        inputSides.add(side.getDirection(sideConfiguration.getDirection()));
                    }
                    if (!inputSides.isEmpty()) {
                        sb.append("-- ").append(LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_MACHINE_INPUTS.getString()).append("\n");
                        sb.append("OUTPUT ").append(resourceTypeKey.m_135782_()).append(":: TO target ");
                        sb.append(inputSides.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", ")));
                        sb.append(" SIDE\n");
                    }
                }
            });
        }
        return sb.toString();
    }

    public static void register(DeferredRegister<ResourceType<?, ?, ?>> types) {
        types.register("gas", GasResourceType::new);
        types.register("infusion", InfuseResourceType::new);
        types.register("pigment", PigmentResourceType::new);
        types.register("slurry", SlurryResourceType::new);
    }
}

