/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.data.thermal_recipe;

import cofh.lib.common.fluid.FluidIngredient;
import cofh.thermal.core.init.registries.TCoreRecipeSerializers;
import cofh.thermal.core.util.recipes.dynamo.CompressionFuel;
import cofh.thermal.core.util.recipes.dynamo.DisenchantmentFuel;
import cofh.thermal.core.util.recipes.dynamo.GourmandFuel;
import cofh.thermal.core.util.recipes.dynamo.LapidaryFuel;
import cofh.thermal.core.util.recipes.dynamo.MagmaticFuel;
import cofh.thermal.core.util.recipes.dynamo.NumismaticFuel;
import cofh.thermal.core.util.recipes.dynamo.StirlingFuel;
import cofh.thermal.lib.util.recipes.DynamoFuelSerializer;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeSerializers;
import mrthomas20121.thermal_extra.recipe.ColdFuel;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class DynamoRecipeBuilder<T extends ThermalFuel> {
    private final DynamoFuelSerializer<T> fuelSerializer;
    private Ingredient i = Ingredient.f_43901_;
    private FluidIngredient fluidIngredient = FluidIngredient.EMPTY;
    private int e = 5000;
    private float energy_mod = 0.0f;

    public static DynamoRecipeBuilder<ColdFuel> cold() {
        return new DynamoRecipeBuilder<ColdFuel>((DynamoFuelSerializer)ThermalExtraRecipeSerializers.COLD_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<NumismaticFuel> numismatic() {
        return new DynamoRecipeBuilder<NumismaticFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.NUMISMATIC_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<MagmaticFuel> magmatic() {
        return new DynamoRecipeBuilder<MagmaticFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.MAGMATIC_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<CompressionFuel> compression() {
        return new DynamoRecipeBuilder<CompressionFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.COMPRESSION_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<GourmandFuel> gourmand() {
        return new DynamoRecipeBuilder<GourmandFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.GOURMAND_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<StirlingFuel> stirling() {
        return new DynamoRecipeBuilder<StirlingFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.STIRLING_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<LapidaryFuel> lapidary() {
        return new DynamoRecipeBuilder<LapidaryFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.LAPIDARY_FUEL_SERIALIZER.get());
    }

    public static DynamoRecipeBuilder<DisenchantmentFuel> disenchantment() {
        return new DynamoRecipeBuilder<DisenchantmentFuel>((DynamoFuelSerializer)TCoreRecipeSerializers.DISENCHANTMENT_FUEL_SERIALIZER.get());
    }

    public DynamoRecipeBuilder(DynamoFuelSerializer<T> fuelSerializer) {
        this.fuelSerializer = fuelSerializer;
    }

    public DynamoRecipeBuilder<T> fluid(FluidStack fluid) {
        this.fluidIngredient = FluidIngredient.of((FluidStack[])new FluidStack[]{fluid});
        return this;
    }

    public DynamoRecipeBuilder<T> ingredient(TagKey<Item> i) {
        this.i = Ingredient.m_204132_(i);
        return this;
    }

    public DynamoRecipeBuilder<T> ingredient(Item i) {
        this.i = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
        return this;
    }

    public DynamoRecipeBuilder<T> ingredient(Block i) {
        this.i = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
        return this;
    }

    public DynamoRecipeBuilder<T> ingredient(Ingredient i) {
        this.i = i;
        return this;
    }

    public DynamoRecipeBuilder<T> energy(int e) {
        this.e = e;
        return this;
    }

    public DynamoRecipeBuilder<T> energyMod(float mod) {
        this.energy_mod = mod;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, String recipeName) {
        consumer.accept(new FinishedDynamoRecipe<T>(this.fuelSerializer, new ResourceLocation(recipeName), this.i, this.e, this.energy_mod));
    }

    public void buildFluid(Consumer<FinishedRecipe> consumer, String recipeName) {
        consumer.accept(new FinishedFluidDynamoRecipe<T>(this.fuelSerializer, new ResourceLocation(recipeName), this.fluidIngredient, this.e, this.energy_mod));
    }

    private record FinishedDynamoRecipe<T extends ThermalFuel>(DynamoFuelSerializer<T> fuelSerializer, ResourceLocation id, Ingredient ingredient, int energy, float energy_mod) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.addProperty("energy", (Number)this.energy);
            if (this.energy_mod > 0.0f) {
                pJson.addProperty("energy_mod", (Number)Float.valueOf(this.energy_mod));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.fuelSerializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    private record FinishedFluidDynamoRecipe<T extends ThermalFuel>(DynamoFuelSerializer<T> fuelSerializer, ResourceLocation id, FluidIngredient ingredient, int energy, float energy_mod) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.toJson());
            pJson.addProperty("energy", (Number)this.energy);
            if (this.energy_mod > 0.0f) {
                pJson.addProperty("energy_mod", (Number)Float.valueOf(this.energy_mod));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.fuelSerializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

