/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.data.thermal_recipe;

import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import mrthomas20121.thermal_extra.data.thermal_recipe.CatalystBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MultiCatalystBuilder {
    private final Map<ResourceLocation, CatalystBuilder<?>> catalystBuilders = new HashMap();
    private Ingredient i;
    private float primary = 1.0f;
    private float secondary = 1.0f;
    private float energy = 1.0f;
    private float minChance = 1.0f;
    private float useChance = 1.0f;

    public MultiCatalystBuilder ingredient(Ingredient ingredient) {
        this.i = ingredient;
        return this;
    }

    public MultiCatalystBuilder ingredient(ItemStack item) {
        return this.ingredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item}));
    }

    public MultiCatalystBuilder ingredient(Item item) {
        return this.ingredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public MultiCatalystBuilder ingredient(TagKey<Item> tag) {
        return this.ingredient(Ingredient.m_204132_(tag));
    }

    public MultiCatalystBuilder primaryMod(float mod) {
        this.primary = mod;
        return this;
    }

    public MultiCatalystBuilder secondaryMod(float mod) {
        this.secondary = mod;
        return this;
    }

    public MultiCatalystBuilder energyMod(float mod) {
        this.energy = mod;
        return this;
    }

    public MultiCatalystBuilder minChanceMod(float mod) {
        this.minChance = mod;
        return this;
    }

    public MultiCatalystBuilder useChanceMod(float mod) {
        this.useChance = mod;
        return this;
    }

    public <T extends ThermalCatalyst> MultiCatalystBuilder addCatalyst(ResourceLocation id, CatalystBuilder<T> catalystBuilder) {
        this.catalystBuilders.put(id, catalystBuilder.ingredient(this.i).primaryMod(this.primary).secondaryMod(this.secondary).energyMod(this.energy).minChanceMod(this.minChance).useChanceMod(this.useChance));
        return this;
    }

    public void save(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        for (Map.Entry<ResourceLocation, CatalystBuilder<?>> entry : this.catalystBuilders.entrySet()) {
            entry.getValue().save(finishedRecipeConsumer, entry.getKey());
        }
    }
}

