/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.item;

import cofh.core.common.item.ArmorItemCoFH;
import cofh.core.common.item.ExcavatorItem;
import cofh.core.common.item.HammerItem;
import cofh.core.common.item.KnifeItem;
import cofh.core.common.item.SickleItem;
import cofh.lib.common.item.AxeItemCoFH;
import cofh.lib.common.item.HoeItemCoFH;
import cofh.lib.common.item.PickaxeItemCoFH;
import cofh.lib.common.item.ShovelItemCoFH;
import cofh.lib.common.item.SwordItemCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import java.util.List;
import mrthomas20121.thermal_extra.item.armor.ExtraArmorItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraftforge.registries.RegistryObject;

public class ToolSetObject {
    private final RegistryObject<AxeItemCoFH> AXE;
    private final RegistryObject<PickaxeItemCoFH> PICKAXE;
    private final RegistryObject<HoeItemCoFH> HOE;
    private final RegistryObject<ShovelItemCoFH> SHOVEL;
    private final RegistryObject<SwordItemCoFH> SWORD;
    private final RegistryObject<ExcavatorItem> EXCAVATOR;
    private final RegistryObject<HammerItem> HAMMER;
    private final RegistryObject<KnifeItem> KNIFE;
    private final RegistryObject<SickleItem> SICKLE;
    private final RegistryObject<ArmorItemCoFH> HELMET;
    private final RegistryObject<ArmorItemCoFH> CHESTPLATE;
    private final RegistryObject<ArmorItemCoFH> LEGGINGS;
    private final RegistryObject<ArmorItemCoFH> BOOTS;

    public ToolSetObject(DeferredRegisterCoFH<Item> registry, String name, Tier tier, ArmorMaterial material, Rarity rarity) {
        this(registry, name, tier, material, rarity, false);
    }

    public ToolSetObject(DeferredRegisterCoFH<Item> registry, String name, Tier tier, ArmorMaterial material, Rarity rarity, boolean aboveNetherite) {
        float swordSpeed;
        Item.Properties properties = new Item.Properties().m_41497_(rarity).m_41487_(1);
        float f = swordSpeed = aboveNetherite ? -2.3f : -2.4f;
        if (aboveNetherite) {
            properties.m_41486_();
        }
        this.AXE = registry.register(name + "_axe", () -> new AxeItemCoFH(tier, 5.0f, -3.0f, properties));
        this.PICKAXE = registry.register(name + "_pickaxe", () -> new PickaxeItemCoFH(tier, 1, -2.8f, properties));
        this.HOE = registry.register(name + "_hoe", () -> new HoeItemCoFH(tier, aboveNetherite ? -4 : -3, aboveNetherite ? 0.0f : 0.5f, properties));
        this.SHOVEL = registry.register(name + "_shovel", () -> new ShovelItemCoFH(tier, 1.5f, -3.0f, properties));
        this.SWORD = registry.register(name + "_sword", () -> new SwordItemCoFH(tier, 3, swordSpeed, properties));
        this.EXCAVATOR = registry.register(name + "_excavator", () -> new ExcavatorItem(tier, properties));
        this.HAMMER = registry.register(name + "_hammer", () -> new HammerItem(tier, properties));
        this.KNIFE = registry.register(name + "_knife", () -> new KnifeItem(tier, properties));
        this.SICKLE = registry.register(name + "_sickle", () -> new SickleItem(tier, properties));
        this.HELMET = registry.register(name + "_helmet", () -> new ExtraArmorItem(material, ArmorItem.Type.HELMET, properties));
        this.CHESTPLATE = registry.register(name + "_chestplate", () -> new ExtraArmorItem(material, ArmorItem.Type.CHESTPLATE, properties));
        this.LEGGINGS = registry.register(name + "_leggings", () -> new ExtraArmorItem(material, ArmorItem.Type.LEGGINGS, properties));
        this.BOOTS = registry.register(name + "_boots", () -> new ExtraArmorItem(material, ArmorItem.Type.BOOTS, properties));
    }

    public RegistryObject<AxeItemCoFH> axe() {
        return this.AXE;
    }

    public RegistryObject<PickaxeItemCoFH> pickaxe() {
        return this.PICKAXE;
    }

    public RegistryObject<HoeItemCoFH> hoe() {
        return this.HOE;
    }

    public RegistryObject<ShovelItemCoFH> shovel() {
        return this.SHOVEL;
    }

    public RegistryObject<SwordItemCoFH> sword() {
        return this.SWORD;
    }

    public RegistryObject<ExcavatorItem> excavator() {
        return this.EXCAVATOR;
    }

    public RegistryObject<HammerItem> hammer() {
        return this.HAMMER;
    }

    public RegistryObject<KnifeItem> knife() {
        return this.KNIFE;
    }

    public RegistryObject<SickleItem> sickle() {
        return this.SICKLE;
    }

    public RegistryObject<ArmorItemCoFH> helmet() {
        return this.HELMET;
    }

    public RegistryObject<ArmorItemCoFH> chestplate() {
        return this.CHESTPLATE;
    }

    public RegistryObject<ArmorItemCoFH> leggings() {
        return this.LEGGINGS;
    }

    public RegistryObject<ArmorItemCoFH> boots() {
        return this.BOOTS;
    }

    public List<RegistryObject<? extends Item>> getALLItems() {
        return List.of(this.sword(), this.axe(), this.pickaxe(), this.shovel(), this.hoe(), this.excavator(), this.hammer(), this.knife(), this.sickle(), this.helmet(), this.chestplate(), this.leggings(), this.boots());
    }
}

