/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.recipe;

import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import mrthomas20121.thermal_extra.recipe.ComponentAssemblyRecipe;
import mrthomas20121.thermal_extra.util.CompoundMapWrapper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ComponentAssemblyRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final ComponentAssemblyRecipeManager INSTANCE = new ComponentAssemblyRecipeManager();
    protected static final int DEFAULT_ENERGY = 6000;
    protected Map<CompoundMapWrapper, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 1;
    protected int maxInputItems = 6;

    public static ComponentAssemblyRecipeManager instance() {
        return INSTANCE;
    }

    private ComponentAssemblyRecipeManager() {
        super(6000);
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (!recipe.getInputFluids().isEmpty()) {
            block16: for (FluidStack fluidInput : ((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()) {
                switch (recipe.getInputItems().size()) {
                    case 1: {
                        for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(firstInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                        }
                        continue block16;
                    }
                    case 2: {
                        for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                            for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                            for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                                for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                }
                            }
                        }
                        continue block16;
                    }
                    case 4: {
                        for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                            for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                                for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                    for (ItemStack forthInput : ((Ingredient)recipe.getInputItems().get(3)).m_43908_()) {
                                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput, forthInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                    }
                                }
                            }
                        }
                        continue block16;
                    }
                    case 5: {
                        for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                            for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                                for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                    for (ItemStack forthInput : ((Ingredient)recipe.getInputItems().get(3)).m_43908_()) {
                                        for (ItemStack firthInput : ((Ingredient)recipe.getInputItems().get(4)).m_43908_()) {
                                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput, forthInput, firthInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                        }
                                    }
                                }
                            }
                        }
                        continue block16;
                    }
                    case 6: {
                        for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                            for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                                for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                    for (ItemStack forthInput : ((Ingredient)recipe.getInputItems().get(3)).m_43908_()) {
                                        for (ItemStack firthInput : ((Ingredient)recipe.getInputItems().get(4)).m_43908_()) {
                                            for (ItemStack sixthInput : ((Ingredient)recipe.getInputItems().get(5)).m_43908_()) {
                                                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput, forthInput, firthInput, sixthInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        continue block16;
                    }
                }
            }
        } else {
            switch (recipe.getInputItems().size()) {
                case 1: {
                    for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(firstInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                    }
                    break;
                }
                case 2: {
                    for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                        for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                        }
                    }
                    break;
                }
                case 3: {
                    for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                        for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                            for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                        for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                            for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                for (ItemStack forthInput : ((Ingredient)recipe.getInputItems().get(3)).m_43908_()) {
                                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput, forthInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                }
                            }
                        }
                    }
                    break;
                }
                case 5: {
                    for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                        for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                            for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                for (ItemStack forthInput : ((Ingredient)recipe.getInputItems().get(3)).m_43908_()) {
                                    for (ItemStack firthInput : ((Ingredient)recipe.getInputItems().get(4)).m_43908_()) {
                                        this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput, forthInput, firthInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
                case 6: {
                    for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).m_43908_()) {
                        for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).m_43908_()) {
                            for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).m_43908_()) {
                                for (ItemStack forthInput : ((Ingredient)recipe.getInputItems().get(3)).m_43908_()) {
                                    for (ItemStack firthInput : ((Ingredient)recipe.getInputItems().get(4)).m_43908_()) {
                                        for (ItemStack sixthInput : ((Ingredient)recipe.getInputItems().get(5)).m_43908_()) {
                                            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Arrays.asList(firstInput, secondInput, thirdInput, forthInput, firthInput, sixthInput), Collections.emptyList(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(ComponentAssemblyRecipeManager.makeComparable((ItemStack)item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackHolder> inputSlots, List<? extends IFluidStackHolder> inputTanks) {
        IMachineRecipe ret;
        if (inputSlots.isEmpty() && inputTanks.isEmpty() || inputSlots.get(0).isEmpty() && inputTanks.get(0).isEmpty() || inputSlots.isEmpty()) {
            return null;
        }
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(this.maxInputItems);
        for (int i = 0; i < this.maxInputItems; ++i) {
            if (inputSlots.get(i).isEmpty()) continue;
            ComparableItemStack compStack = ComponentAssemblyRecipeManager.makeNBTComparable((ItemStack)inputSlots.get(i).getItemStack());
            convertedItems.add(compStack);
        }
        if ((inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) && convertedItems.isEmpty()) {
            return null;
        }
        if (convertedItems.isEmpty()) {
            return null;
        }
        IMachineRecipe iMachineRecipe = ret = inputTanks.isEmpty() || inputTanks.get(0).isEmpty() ? this.recipeMap.get(CompoundMapWrapper.of(convertedItems)) : this.recipeMap.get(CompoundMapWrapper.of(convertedItems, inputTanks.get(0).getFluidStack()));
        if (ret == null) {
            convertedItems.clear();
            for (int i = 0; i < this.maxInputItems; ++i) {
                if (inputSlots.get(i).isEmpty()) continue;
                ComparableItemStack compStack = ComponentAssemblyRecipeManager.makeComparable((ItemStack)inputSlots.get(i).getItemStack());
                convertedItems.add(compStack);
            }
            if (convertedItems.isEmpty()) {
                return null;
            }
            ret = inputTanks.isEmpty() || inputTanks.get(0).isEmpty() ? this.recipeMap.get(CompoundMapWrapper.of(convertedItems)) : this.recipeMap.get(CompoundMapWrapper.of(convertedItems, inputTanks.get(0).getFluidStack()));
        }
        return ret;
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty()) {
            return null;
        }
        if (inputItems.size() > this.maxInputItems || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        for (ItemStack stack : inputItems) {
            if (!stack.m_41619_()) continue;
            return null;
        }
        for (ItemStack stack : outputItems) {
            if (!stack.m_41619_()) continue;
            return null;
        }
        ObjectArrayList key = new ObjectArrayList();
        FluidStack fluidStack = FluidStack.EMPTY;
        if (inputFluids.isEmpty()) {
            for (ItemStack stack : inputItems) {
                ComparableItemStack comparableItemStack = ComponentAssemblyRecipeManager.makeNBTComparable((ItemStack)stack);
                this.validItems.add(comparableItemStack);
                key.add(comparableItemStack);
            }
        } else {
            for (ItemStack stack : inputItems) {
                ComparableItemStack comparableItemStack = ComponentAssemblyRecipeManager.makeNBTComparable((ItemStack)stack);
                this.validItems.add(comparableItemStack);
                key.add(comparableItemStack);
            }
            FluidStack inputFluid = inputFluids.get(0);
            if (inputFluid.isEmpty()) {
                return null;
            }
            this.validFluids.add(inputFluid.getFluid());
            fluidStack = inputFluid;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(fluidStack.isEmpty() ? CompoundMapWrapper.of((List<ComparableItemStack>)key) : CompoundMapWrapper.of((List<ComparableItemStack>)key, fluidStack), (IMachineRecipe)recipe);
        return recipe;
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        List recipes = recipeManager.m_44013_((RecipeType)ThermalExtraRecipeTypes.COMPONENT_ASSEMBLY.get());
        for (ComponentAssemblyRecipe entry : recipes) {
            this.addRecipe(entry);
        }
    }
}

