/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.util;

import cofh.lib.util.crafting.ComparableItemStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fluids.FluidStack;

public class CompoundMapWrapper {
    protected final Set<Integer> itemHashes;
    protected int hashCode;

    public static CompoundMapWrapper of(List<ComparableItemStack> itemStacks) {
        return new CompoundMapWrapper(itemStacks);
    }

    public static SingleFluidCompoundMapWrapper of(List<ComparableItemStack> itemStacks, FluidStack fluidStack) {
        return new SingleFluidCompoundMapWrapper(itemStacks, fluidStack);
    }

    public static FluidCompoundMapWrapper of(List<ComparableItemStack> itemStacks, List<FluidStack> fluidStack) {
        return new FluidCompoundMapWrapper(itemStacks, fluidStack);
    }

    protected CompoundMapWrapper(List<ComparableItemStack> itemStacks) {
        this.itemHashes = new ObjectOpenHashSet(itemStacks.size());
        for (ComparableItemStack itemStack : itemStacks) {
            if (itemStack.hashCode() == 0) continue;
            this.itemHashes.add(itemStack.hashCode());
            this.hashCode += itemStack.hashCode();
        }
    }

    public boolean equals(Object o) {
        if (null == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundMapWrapper that = (CompoundMapWrapper)o;
        return this.itemHashes.size() == that.itemHashes.size() && this.itemHashes.containsAll(that.itemHashes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class SingleFluidCompoundMapWrapper
    extends CompoundMapWrapper {
        public SingleFluidCompoundMapWrapper(List<ComparableItemStack> itemStacks, FluidStack fluidStacks) {
            super(itemStacks);
            this.hashCode += fluidStacks.hashCode();
        }
    }

    public static class FluidCompoundMapWrapper
    extends CompoundMapWrapper {
        protected final Set<Integer> fluidHashes;

        public FluidCompoundMapWrapper(List<ComparableItemStack> itemStacks, List<FluidStack> fluidStacks) {
            super(itemStacks);
            this.fluidHashes = new ObjectOpenHashSet(itemStacks.size());
            for (FluidStack stack : fluidStacks) {
                this.fluidHashes.add(stack.hashCode());
                this.hashCode += stack.hashCode();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (null == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidCompoundMapWrapper that = (FluidCompoundMapWrapper)o;
            return this.itemHashes.size() == that.itemHashes.size() && this.itemHashes.containsAll(that.itemHashes) && this.fluidHashes.size() == that.fluidHashes.size() && this.fluidHashes.containsAll(that.fluidHashes);
        }
    }
}

