/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.client.render;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.client.render.TranslocatorPartRenderer;
import codechicken.translocators.part.FluidTranslocatorPart;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidTranslocatorPartRenderer
extends TranslocatorPartRenderer<FluidTranslocatorPart> {
    @Override
    public void renderDynamic(FluidTranslocatorPart part, PoseStack pStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        super.renderDynamic(part, pStack, buffers, packedLight, packedOverlay, partialTicks);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(RenderUtils.getFluidRenderType(), buffers);
        double time = ClientUtils.getRenderTime();
        Matrix4 mat = new Matrix4(pStack);
        for (FluidTranslocatorPart.MovingLiquid m : part.getMovingLiquids()) {
            double start = MathHelper.interpolate((double)m.b_start, (double)m.a_start, (double)partialTicks);
            double end = MathHelper.interpolate((double)m.b_end, (double)m.a_end, (double)partialTicks);
            FluidTranslocatorPartRenderer.drawLiquidSpiral(ccrs, mat, part.side, m.dst, m.liquid, start, end, time, 0.0);
            if (!part.fast) continue;
            FluidTranslocatorPartRenderer.drawLiquidSpiral(ccrs, mat, part.side, m.dst, m.liquid, start, end, time, 0.5);
        }
    }

    private static void drawLiquidSpiral(CCRenderState ccrs, Matrix4 mat, int src, int dst, FluidStack stack, double start, double end, double time, double theta0) {
        if (stack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        Material material = ForgeHooksClient.getBlockMaterial((ResourceLocation)props.getStillTexture(stack));
        TextureAtlasSprite tex = material.m_119204_();
        ccrs.colour = props.getTintColor(stack) << 8 | 0xFF;
        Vector3[] last = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        Vector3[] next = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        double tess = 0.05;
        Vector3 a = FluidTranslocatorPartRenderer.getPerp(src, dst);
        boolean rev = FluidTranslocatorPartRenderer.sum(a.copy().crossProduct(FluidTranslocatorPartRenderer.getPathNormal(src, dst, 0.0))) != FluidTranslocatorPartRenderer.sum(sideVec[src]);
        for (double di = end; di <= start; di += tess) {
            Vector3 b = FluidTranslocatorPartRenderer.getPathNormal(src, dst, di);
            Vector3 c = FluidTranslocatorPartRenderer.getPath(src, dst, di);
            if (rev) {
                b.negate();
            }
            double r = (2.0 * di - time / 10.0 + theta0 + (double)(dst / 6)) * 2.0 * Math.PI;
            double sz = 0.1;
            Vector3 p = c.add(a.copy().multiply(Math.sin(r) * sz)).add(b.copy().multiply(Math.cos(r) * sz));
            double s1 = 0.02;
            double s2 = -0.02;
            next[0].set(p).add(a.x * s1 + b.x * s1, a.y * s1 + b.y * s1, a.z * s1 + b.z * s1);
            next[1].set(p).add(a.x * s2 + b.x * s1, a.y * s2 + b.y * s1, a.z * s2 + b.z * s1);
            next[2].set(p).add(a.x * s2 + b.x * s2, a.y * s2 + b.y * s2, a.z * s2 + b.z * s2);
            next[3].set(p).add(a.x * s1 + b.x * s2, a.y * s1 + b.y * s2, a.z * s1 + b.z * s2);
            if (di > end) {
                double u1 = tex.m_118367_(Math.abs(di) * 16.0);
                double u2 = tex.m_118367_(Math.abs(di - tess) * 16.0);
                for (int i = 0; i < 4; ++i) {
                    int j = (i + 1) % 4;
                    Vector3 axis = next[j].copy().subtract(next[i]);
                    double v1 = tex.m_118393_(Math.abs(next[i].scalarProject(axis)) * 16.0);
                    double v2 = tex.m_118393_(Math.abs(next[j].scalarProject(axis)) * 16.0);
                    ccrs.vert.set(next[i], u1, v1).apply((Transformation)mat);
                    ccrs.writeVert();
                    ccrs.vert.set(next[j], u1, v2).apply((Transformation)mat);
                    ccrs.writeVert();
                    ccrs.vert.set(last[j], u2, v2).apply((Transformation)mat);
                    ccrs.writeVert();
                    ccrs.vert.set(last[i], u2, v1).apply((Transformation)mat);
                    ccrs.writeVert();
                }
            }
            Vector3[] tmp = last;
            last = next;
            next = tmp;
        }
    }

    private static Vector3 getPathNormal(int srcSide, int dstSide, double d) {
        if ((srcSide ^ 1) == dstSide) {
            return sideVec[(srcSide + 4) % 6].copy();
        }
        double sind = Math.sin(d * Math.PI / 2.0);
        double cosd = Math.cos(d * Math.PI / 2.0);
        Vector3 vsrc = sideVec[srcSide ^ 1].copy();
        Vector3 vdst = sideVec[dstSide ^ 1].copy();
        return vsrc.multiply(sind).add(vdst.multiply(cosd)).normalize();
    }

    private static double sum(Vector3 v) {
        return v.x + v.y + v.z;
    }
}

