/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.client.render;

import codechicken.lib.render.CCRenderEventHandler;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.tile.TileCraftingGrid;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TileCraftingGridRenderer
implements BlockEntityRenderer<TileCraftingGrid> {
    public TileCraftingGridRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TileCraftingGrid tile, float partialTicks, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        TextureAtlasSprite icon = TranslocatorTextures.CRAFTING_GRID;
        Matrix4 mat = new Matrix4(mStack);
        mat.translate(0.0, 0.001, 0.0);
        ccrs.bind(RenderType.m_110463_(), buffers, mat);
        ccrs.normal.set(0.0, 1.0, 0.0);
        ccrs.vert.set(1.0, 0.0, 0.0, (double)icon.m_118409_(), (double)icon.m_118411_());
        ccrs.writeVert();
        ccrs.vert.set(0.0, 0.0, 0.0, (double)icon.m_118409_(), (double)icon.m_118412_());
        ccrs.writeVert();
        ccrs.vert.set(0.0, 0.0, 1.0, (double)icon.m_118410_(), (double)icon.m_118412_());
        ccrs.writeVert();
        ccrs.vert.set(1.0, 0.0, 1.0, (double)icon.m_118410_(), (double)icon.m_118411_());
        ccrs.writeVert();
        mStack.m_85836_();
        mStack.m_85837_(0.5, 0.0, 0.5);
        Transformation orient = Rotation.quarterRotations[tile.rotation];
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = tile.items[i];
            if (stack.m_41619_()) continue;
            int row = i / 3;
            int col = i % 3;
            Vector3 pos = new Vector3((double)((col - 1) * 5) / 16.0, 0.1 + 0.01 * Math.sin((double)i * 1.7 + ClientUtils.getRenderTime() / 5.0), (double)((row - 1) * 5) / 16.0).apply(orient);
            mStack.m_85836_();
            mStack.m_85837_(pos.x, pos.y, pos.z);
            mStack.m_85841_(0.35f, 0.35f, 0.35f);
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, mStack, buffers, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
            mStack.m_85849_();
        }
        if (!tile.result.m_41619_()) {
            mStack.m_85836_();
            mStack.m_85837_(0.0, 0.6 + 0.02 * Math.sin(ClientUtils.getRenderTime() / 10.0), 0.0);
            mStack.m_85841_(0.8f, 0.8f, 0.8f);
            float spin = (float)(ClientUtils.getRenderTime() * 9.0 / Math.PI);
            float bob = (float)(Math.sin(((float)CCRenderEventHandler.renderTime + spin) / 20.0f) * (double)0.1f + (double)0.1f);
            mStack.m_85837_(0.0, (double)bob + 0.25, 0.0);
            mStack.m_252781_(Axis.f_252436_.m_252961_(((float)CCRenderEventHandler.renderTime + spin) / 30.0f));
            itemRenderer.m_269128_(tile.result, ItemDisplayContext.FIXED, packedLight, packedOverlay, mStack, buffers, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
            mStack.m_85849_();
        }
        mStack.m_85849_();
    }
}

