/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import codechicken.multipart.util.PartRayTraceResult;
import codechicken.translocators.container.ContainerItemTranslocator;
import codechicken.translocators.handler.ConfigHandler;
import codechicken.translocators.init.TranslocatorsModContent;
import codechicken.translocators.part.TranslocatorPart;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemTranslocatorPart
extends TranslocatorPart
implements RedstonePart {
    public boolean regulate;
    public boolean signal;
    public boolean a_powering;
    public ItemStack regulateStack = ItemStack.f_41583_;
    public ItemStack[] filters = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[9], (Object)ItemStack.f_41583_);
    public List<MovingItem> movingItems = new LinkedList<MovingItem>();

    public MultipartType<?> getType() {
        return (MultipartType)TranslocatorsModContent.itemTranslocatorPartType.get();
    }

    @Override
    public int getTType() {
        return 0;
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)TranslocatorsModContent.itemTranslocatorItem.get(), 1);
    }

    @Override
    public int getIconIndex() {
        int i = super.getIconIndex();
        if (this.regulate) {
            i |= 8;
        }
        if (this.signal) {
            i |= this.a_powering ? 32 : 16;
        }
        return i;
    }

    @Override
    public boolean canStay() {
        return this.capCache().getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.f_122348_[this.side]).isPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().m_5776_()) {
            this.movingItems.removeIf(MovingItem::update);
        } else {
            IItemHandler[] handlers;
            if (this.a_eject) {
                handlers = new IItemHandler[6];
                for (int i = 0; i < 6; ++i) {
                    handlers[i] = this.canInsert(i) || i == this.side ? (IItemHandler)this.capCache().getCapabilityOr(ForgeCapabilities.ITEM_HANDLER, Direction.f_122348_[i], (Object)EmptyHandler.INSTANCE) : EmptyHandler.INSTANCE;
                }
                IItemHandler myHandler = handlers[this.side];
                int largestSize = 0;
                int largestSlot = 0;
                for (int slot = 0; slot < myHandler.getSlots(); ++slot) {
                    int size;
                    ItemStack stack = myHandler.getStackInSlot(slot);
                    if (stack.m_41619_() || !InventoryUtils.canExtractStack((IItemHandler)myHandler, (int)slot)) continue;
                    int n = size = this.fast ? stack.m_41613_() : 1;
                    if (size <= largestSize || (size = Math.min(size, ItemTranslocatorPart.getExtractableAmount(stack, this, myHandler))) <= largestSize || (size = Math.min(size, ItemTranslocatorPart.getInsertableAmount(stack, this, handlers))) <= largestSize) continue;
                    largestSlot = slot;
                    largestSize = size;
                }
                if (largestSize > 0) {
                    ItemStack move = myHandler.extractItem(largestSlot, largestSize, true);
                    move = move.m_41777_();
                    int initialCount = move.m_41613_();
                    ArrayList<MovingItem> transfers = new ArrayList<MovingItem>();
                    this.spreadOutput(move, false, handlers, transfers);
                    this.spreadOutput(move, true, handlers, transfers);
                    myHandler.extractItem(largestSlot, initialCount - move.m_41613_(), false);
                    this.sendTransferPacket(transfers);
                }
            }
            if (this.signal) {
                handlers = new IItemHandler[6];
                for (int i = 0; i < 6; ++i) {
                    handlers[i] = (IItemHandler)this.capCache().getCapabilityOr(ForgeCapabilities.ITEM_HANDLER, Direction.f_122348_[this.side], (Object)EmptyHandler.INSTANCE);
                }
                if (this.a_eject) {
                    boolean allSatisfied = true;
                    for (int i = 0; i < 6; ++i) {
                        MultiPart other = this.tile().getSlottedPart(i);
                        if (!(other instanceof ItemTranslocatorPart)) continue;
                        ItemTranslocatorPart otherPart = (ItemTranslocatorPart)other;
                        if (otherPart.a_eject || otherPart.isSatisfied(handlers[i])) continue;
                        allSatisfied = false;
                    }
                    this.setPowering(allSatisfied);
                } else {
                    this.setPowering(!this.canTransferFilter(handlers[this.side], handlers));
                }
            }
        }
    }

    private void sendTransferPacket(List<MovingItem> transfers) {
        this.sendIncUpdate(packet -> {
            packet.writeVarInt(transfers.size());
            for (MovingItem transfer : transfers) {
                packet.writeByte(transfer.dst);
                packet.writeItemStack(transfer.stack);
            }
        });
    }

    private boolean canTransferFilter(IItemHandler access, IItemHandler[] attached) {
        boolean filterSet = false;
        for (ItemStack filter : this.filters) {
            if (filter.m_41619_()) continue;
            filterSet = true;
            if (this.regulate && InventoryUtils.countMatchingStacks((IItemHandler)access, (ItemStack)filter, (boolean)false) <= ItemTranslocatorPart.filterCount(this, filter) || ItemTranslocatorPart.getInsertableAmount(filter, this, attached) <= 0) continue;
            return true;
        }
        return !filterSet;
    }

    private boolean isSatisfied(IItemHandler handler) {
        boolean filterSet = false;
        for (ItemStack filter : this.filters) {
            if (filter.m_41619_()) continue;
            filterSet = true;
            if (!(this.regulate ? InventoryUtils.countMatchingStacks((IItemHandler)handler, (ItemStack)filter, (!this.a_eject ? 1 : 0) != 0) < ItemTranslocatorPart.filterCount(this, filter) : InventoryUtils.getInsertableQuantity((IItemHandler)handler, (ItemStack)filter) > 0)) continue;
            return false;
        }
        return filterSet || !this.hasEmptySpace(handler);
    }

    private boolean hasEmptySpace(IItemHandler handler) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            boolean b;
            ItemStack stack = handler.getStackInSlot(slot);
            boolean bl = b = stack.m_41619_() || stack.m_41753_() && stack.m_41613_() < Math.min(stack.m_41741_(), handler.getSlotLimit(slot));
            if (!InventoryUtils.canInsertStack((IItemHandler)handler, (int)slot, (ItemStack)new ItemStack((ItemLike)Items.f_42415_)) || !b) continue;
            return true;
        }
        return false;
    }

    private void spreadOutput(ItemStack move, boolean rspass, IItemHandler[] attached, List<MovingItem> transfers) {
        if (move.m_41613_() == 0) {
            return;
        }
        int outputCount = 0;
        int[] outputQuantities = new int[6];
        for (byte i = 0; i < 6; ++i) {
            ItemTranslocatorPart part;
            MultiPart p = this.tile().getSlottedPart((int)i);
            if (!(p instanceof ItemTranslocatorPart) || (part = (ItemTranslocatorPart)p).canEject() || part.redstone != rspass || i == this.side) continue;
            outputQuantities[i] = ItemTranslocatorPart.getInsertableAmount(move, part, attached[i]);
            if (outputQuantities[i] <= 0) continue;
            ++outputCount;
        }
        for (int dst = 0; dst < 6 && move.m_41613_() > 0; ++dst) {
            int qty = outputQuantities[dst];
            if (qty <= 0) continue;
            qty = Math.min(qty, move.m_41613_() / outputCount + this.level().f_46441_.m_188503_(move.m_41613_() % outputCount + 1));
            --outputCount;
            if (qty == 0) continue;
            IItemHandler handler = attached[dst];
            ItemStack add = ItemUtils.copyStack((ItemStack)move, (int)qty);
            ItemStack remain = InventoryUtils.insertItem((IItemHandler)handler, (ItemStack)add, (boolean)false);
            move.m_41774_(qty - remain.m_41613_());
            add.m_41774_(remain.m_41613_());
            if (add.m_41619_()) continue;
            transfers.add(new MovingItem(dst, add));
        }
    }

    private static int filterCount(ItemTranslocatorPart part, ItemStack stack) {
        boolean filterSet = false;
        int match = 0;
        for (ItemStack filter : part.filters) {
            if (filter.m_41619_()) continue;
            filterSet = true;
            if (!ItemUtils.areStacksSameType((ItemStack)stack, (ItemStack)filter)) continue;
            match += filter.m_41613_();
        }
        return filterSet ? match : -1;
    }

    private static int getInsertableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler[] handler) {
        int insertableAmount = 0;
        for (int i = 0; i < 6; ++i) {
            if (!me.canInsert(i)) continue;
            insertableAmount += ItemTranslocatorPart.getInsertableAmount(stack, (ItemTranslocatorPart)((Object)me.getOther(i)), handler[i]);
        }
        return insertableAmount;
    }

    private static int getInsertableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler range) {
        int filter = ItemTranslocatorPart.filterCount(me, stack);
        if (filter == 0) {
            return 0;
        }
        int fit = InventoryUtils.getInsertableQuantity((IItemHandler)range, (ItemStack)stack);
        if (fit == 0) {
            return 0;
        }
        if (me.regulate && filter > 0) {
            fit = Math.min(fit, filter - InventoryUtils.countMatchingStacks((IItemHandler)range, (ItemStack)stack, (boolean)true));
        }
        return Math.max(fit, 0);
    }

    private static int getExtractableAmount(ItemStack stack, ItemTranslocatorPart me, IItemHandler handler) {
        int qty;
        int filter = ItemTranslocatorPart.filterCount(me, stack);
        if (filter == 0) {
            return me.regulate ? stack.m_41741_() : 0;
        }
        int n = qty = filter < 0 ? stack.m_41741_() : filter;
        if (me.regulate && filter > 0) {
            qty = Math.min(qty, InventoryUtils.countMatchingStacks((IItemHandler)handler, (ItemStack)stack, (boolean)false) - filter);
        }
        return Math.max(qty, 0);
    }

    @Override
    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack held, InteractionHand hand) {
        if (this.level().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ConfigHandler.regulateTag) && !this.regulate) {
            this.regulateStack = ItemUtils.copyStack((ItemStack)stack, (int)1);
            this.regulate = true;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.markUpdate();
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42416_ && !this.signal) {
            this.signal = true;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.markUpdate();
            return InteractionResult.SUCCESS;
        }
        return super.activate(player, hit, stack, hand);
    }

    @Override
    public void stripModifiers() {
        super.stripModifiers();
        if (this.regulate) {
            this.regulate = false;
            this.dropItem(this.regulateStack);
            this.regulateStack = ItemStack.f_41583_;
        }
        if (this.signal) {
            this.setPowering(false);
            this.signal = false;
            this.dropItem(new ItemStack((ItemLike)Items.f_42416_));
        }
    }

    @Override
    public void openGui(Player player) {
        this.openItemGui(player, this.filters, this.regulate ? "gui.translocators.regulate" : "gui.translocators.filter");
    }

    private void openItemGui(Player player, ItemStack[] filters, String name) {
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, p) -> {
            class Inv
            extends InventorySimple {
                public Inv(ItemStack[] items, int limit) {
                    super(items, limit);
                }

                public void m_6596_() {
                    ItemTranslocatorPart.this.markUpdate();
                }
            }
            return new ContainerItemTranslocator(id, inv, new Inv(filters, this.filterStackLimit()));
        }, (Component)Component.m_237115_((String)name));
        ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, p -> p.writeShort(this.filterStackLimit()));
    }

    private int filterStackLimit() {
        if (this.regulate) {
            return 65535;
        }
        if (this.fast) {
            return 64;
        }
        return 1;
    }

    public void setPowering(boolean b) {
        if ((this.signal || !b) && b != this.a_powering) {
            this.a_powering = b;
            this.level().m_46672_(this.pos(), Blocks.f_50088_);
            this.level().m_46672_(this.pos().m_121945_(Direction.f_122348_[this.side]), Blocks.f_50088_);
            this.markUpdate();
        }
    }

    @Override
    public void readIncUpdate(MCDataInput packet) {
        int expected = packet.readVarInt();
        for (int i = 0; i < expected; ++i) {
            byte dst = packet.readByte();
            ItemStack stack = packet.readItemStack();
            this.movingItems.add(new MovingItem(dst, stack));
        }
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128379_("regulate", this.regulate);
        tag.m_128379_("signal", this.signal);
        tag.m_128379_("powering", this.a_powering);
        tag.m_128365_("filters", (Tag)InventoryUtils.writeItemStacksToTag((ItemStack[])this.filters, (int)65536));
        tag.m_128365_("regulateStack", (Tag)this.regulateStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.regulate = tag.m_128471_("regulate");
        this.signal = tag.m_128471_("signal");
        this.a_powering = tag.m_128471_("powering");
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.filters, (ListTag)tag.m_128437_("filters", 10));
        this.regulateStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("regulateStack"));
    }

    @Override
    protected int writeFlags() {
        int flags = super.writeFlags();
        flags |= (this.regulate ? 1 : 0) << 3;
        flags |= (this.signal ? 1 : 0) << 4;
        return flags |= (this.a_powering ? 1 : 0) << 5;
    }

    @Override
    protected void readFlags(int flags) {
        super.readFlags(flags);
        this.regulate = (flags & 8) != 0;
        this.signal = (flags & 0x10) != 0;
        this.a_powering = (flags & 0x20) != 0;
    }

    public int strongPowerLevel(int side) {
        return this.a_powering && side == this.side ? 15 : 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public boolean canConnectRedstone(int side) {
        return this.redstone;
    }

    public static class MovingItem {
        public int dst;
        public ItemStack stack;
        public double a_progress;
        public double b_progress;

        public MovingItem(int dst, ItemStack stack) {
            this.dst = dst;
            this.stack = stack;
        }

        public boolean update() {
            if (this.a_progress >= 1.0) {
                return true;
            }
            this.b_progress = this.a_progress;
            this.a_progress = MathHelper.approachLinear((double)this.a_progress, (double)1.0, (double)0.2);
            return false;
        }
    }
}

