/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.network.NetworkHandler;
import tv.soaryn.xycraft.core.utils.IRegister;
import tv.soaryn.xycraft.machines.XyMachinesClient;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachineRecipes;
import tv.soaryn.xycraft.machines.content.MachineRuleTests;
import tv.soaryn.xycraft.machines.content.MachinesAttributes;
import tv.soaryn.xycraft.machines.content.MachinesCommands;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesMenuContent;
import tv.soaryn.xycraft.machines.content.MachinesSounds;
import tv.soaryn.xycraft.machines.content.blocks.CollectorBlock;
import tv.soaryn.xycraft.machines.content.blocks.HoverPylonBlock;
import tv.soaryn.xycraft.machines.content.blocks.basic.LightFieldBlock;
import tv.soaryn.xycraft.machines.content.blocks.basic.WaterBlock;
import tv.soaryn.xycraft.machines.content.items.HoverPackItem;
import tv.soaryn.xycraft.machines.content.items.modular.GauntletItem;
import tv.soaryn.xycraft.machines.content.multiblock.TankMultiBlock;
import tv.soaryn.xycraft.machines.data.MachineLootModifierContent;
import tv.soaryn.xycraft.machines.network.CBCollectorAbsorbedPacket;
import tv.soaryn.xycraft.machines.network.CBFreezeBlockPacket;
import tv.soaryn.xycraft.machines.network.CBRainShieldBlockPacket;
import tv.soaryn.xycraft.machines.network.CBTankFluidUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBTankFormPacket;
import tv.soaryn.xycraft.machines.network.CBTankUnformPacket;
import tv.soaryn.xycraft.machines.network.SBOpenTankMenu;

@Mod(value="xycraft_machines")
public class XyMachines
extends XyCraft {
    public static final String ModId = "xycraft_machines";
    public static NetworkHandler NETWORK_HANDLER = NetworkHandler.builder((String)"xycraft_machines", (String)"xycraft_machines", (int)0).register(CBTankFormPacket.class, CBTankFormPacket.SERDES).register(CBTankUnformPacket.class, CBTankUnformPacket.SERDES).register(CBTankFluidUpdatePacket.class, CBTankFluidUpdatePacket.SERDES).register(CBCollectorAbsorbedPacket.class, CBCollectorAbsorbedPacket.SERDES).register(SBOpenTankMenu.class, SBOpenTankMenu.SERDES).register(CBFreezeBlockPacket.class, CBFreezeBlockPacket.SERDES).register(CBRainShieldBlockPacket.class, CBRainShieldBlockPacket.SERDES).build();

    public XyMachines() {
        super(new IRegister[]{MachinesContent.Map, MachinesMenuContent.Instance, MachineRecipes.Instance, MachineRuleTests.Instance, MachinesConfig.Instance, MachinesSounds.Instance, MachinesAttributes.Instance, MachineLootModifierContent.Instance});
        this.modEventBus.addListener(this::commonSetup);
        this.modEventBus.addListener(this::addToCreativeTabs);
        this.modEventBus.addListener(XyMachines::onEntityAttributeModification);
        MinecraftForge.EVENT_BUS.addListener(MachinesCommands::registerCommands);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.modEventBus.addListener(XyMachinesClient::init));
        TankMultiBlock.init();
    }

    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)MachinesAttributes.HoverFlight.get());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LightFieldBlock.init();
        HoverPylonBlock.init();
        HoverPackItem.init();
        CollectorBlock.init();
        WaterBlock.init();
        GauntletItem.GauntletEvents.init();
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.m_8055_(relativePos).m_60713_(MachinesContent.WaterBlock.block()), fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : Blocks.f_50652_.m_49966_()));
        event.enqueueWork(() -> MachinesContent.Map.MappedContent.forEach(IContent::setToolTip));
    }

    private void addToCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        IContent[] itemsInTab;
        for (IContent content2 : itemsInTab = (IContent[])MachinesContent.Map.MappedContent.stream().filter(content -> content.tab() != null && content.tab().isPresent() && content.tab().get() == event.getTab()).toArray(IContent[]::new)) {
            if (content2 instanceof ItemContent) {
                ItemContent itemContent = (ItemContent)content2;
                if (content2 == MachinesContent.IncompleteProcessor) {
                    if (!CompatContent.AE2.Mod.isLoaded() || !CompatContent.Create.Mod.isLoaded()) continue;
                    event.m_246326_((ItemLike)itemContent);
                    continue;
                }
                event.m_246326_((ItemLike)itemContent.item());
                continue;
            }
            if (!(content2 instanceof BlockContent)) continue;
            BlockContent blockContent = (BlockContent)content2;
            event.m_246326_((ItemLike)blockContent);
        }
    }
}

