/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.content.multiblock;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.content.multiblock.ClientTankCache;
import tv.soaryn.xycraft.machines.client.content.multiblock.ClientTankMultiBlock;
import tv.soaryn.xycraft.machines.client.render.TankMultiBlockRenderer;
import tv.soaryn.xycraft.machines.content.multiblock.TankMultiBlock;
import tv.soaryn.xycraft.machines.network.SBOpenTankMenu;

public class ClientTankEventHandler {
    private static WeakReference<ClientTankMultiBlock> LAST_LOOKED_AT = new WeakReference<Object>(null);

    @Nullable
    public static ClientTankMultiBlock getLookedAt(Level level, BlockPos pos) {
        ClientTankMultiBlock lastLookedAt = (ClientTankMultiBlock)LAST_LOOKED_AT.get();
        if (lastLookedAt == null) {
            ClientTankMultiBlock multiBlock = TankMultiBlock.find(level, pos, ClientTankMultiBlock.class).orElse(null);
            LAST_LOOKED_AT = new WeakReference<ClientTankMultiBlock>(multiBlock);
            return multiBlock;
        }
        List<ClientTankMultiBlock> all = TankMultiBlock.findAll(level, pos, ClientTankMultiBlock.class).toList();
        if (all.contains(lastLookedAt)) {
            return lastLookedAt;
        }
        if (all.isEmpty()) {
            return null;
        }
        ClientTankMultiBlock multiBlock = all.get(0);
        LAST_LOOKED_AT = new WeakReference<ClientTankMultiBlock>(multiBlock);
        return multiBlock;
    }

    public static Iterable<ClientTankMultiBlock> getAllTanks() {
        return ClientTankCache.of((Level)Minecraft.m_91087_().f_91073_).list();
    }

    private static void onClientLevelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.m_5776_()) {
            return;
        }
        ClientTankCache.of(event.level).list().forEach(ClientTankMultiBlock::tick);
    }

    private static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!level.m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_36341_() || ModifierKeyCapability.of((Player)player)) {
            return;
        }
        ClientTankMultiBlock tank = ClientTankEventHandler.getLookedAt(event.getLevel(), event.getPos());
        if (tank != null) {
            XyMachines.NETWORK_HANDLER.send((Packet.ServerBound)new SBOpenTankMenu(tank.getOrigin(), event.getPos(), event.getHand()));
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientTankEventHandler::onClientLevelTick);
        MinecraftForge.EVENT_BUS.addListener(ClientTankEventHandler::onRightClick);
        MinecraftForge.EVENT_BUS.addListener(TankMultiBlockRenderer::onRenderLevel);
        MinecraftForge.EVENT_BUS.addListener(TankMultiBlockRenderer::onDrawHighlight);
    }
}

