/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IColorData;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.IPacketDataSync;
import tv.soaryn.xycraft.core.content.capabilities.player.ColorCapability;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.core.utils.container.SimpleItemContainer;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.items.modular.IModule;
import tv.soaryn.xycraft.machines.content.items.modular.IModuleStorage;
import tv.soaryn.xycraft.machines.gui.EngineeringTableMenu;

public class EngineeringTableBlock
extends XyBlock.WithEntity
implements IColored {
    private static final VoxelShape Shape = Shapes.m_83110_((VoxelShape)EngineeringTableBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)EngineeringTableBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public EngineeringTableBlock() {
        super(MachinesContent.MachineProperties().m_60955_().m_246843_(new FeatureFlag[]{FeatureFlags.f_244112_}), () -> ((BlockContent)MachinesContent.EngineeringTable).entity());
    }

    public boolean m_7923_(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(interactionHand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (interactionHand == InteractionHand.MAIN_HAND && dyeColor != null) {
            ColorSource.Dye color = new ColorSource.Dye(dyeColor);
            if (be instanceof Entity) {
                Entity entity = (Entity)be;
                if (color.getColor() != entity.getData().getColor().getColor()) {
                    entity.getData().setColor((ColorSource)color);
                    be.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_46597_(pos, state);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
        }
        if (be instanceof Entity) {
            Entity entity = (Entity)be;
            if (!level.m_5776_() && !(player instanceof FakePlayer)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)entity, (BlockPos)be.m_58899_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            return entity.getData().getColor().getColor();
        }
        return super.getColorOfBlock(state, level, pos, index);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return ColorCapability.colorOf((Player)Utils.getClientPlayer());
    }

    public static class Entity
    extends CoreBlockEntity
    implements MenuProvider {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.EngineeringTable.entity(), pos, state);
            this.Data = new EngineeringTableData();
            this.getData().setColor((ColorSource)CustomColors.Blue);
        }

        public EngineeringTableData getData() {
            return (EngineeringTableData)this.Data;
        }

        public static BlockEntityType<?> supplier(Block block) {
            return new BlockEntityType(Entity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
        }

        @NotNull
        public Component m_5446_() {
            return Component.m_237115_((String)"block.xycraft_machines.engineering_table");
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            return new EngineeringTableMenu(windowId, playerInventory, (BlockEntity)this, (ItemContainer)this.getData().Inventory, (ContainerData)this.getData().MenuData);
        }

        public class EngineeringTableData
        implements IDataSync,
        IColorData,
        IPacketDataSync {
            public SimpleContainerData MenuData = new SimpleContainerData(1);
            public ItemContainer.Serializable Inventory = new Container(() -> ((Entity)Entity.this).m_6596_()){

                public void set(int slot, @NotNull ItemStack stack) {
                    super.set(slot, stack);
                }
            };

            public void onLoad(CoreBlockEntity coreBlockEntity) {
            }

            public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                tag.m_128405_("color", this.MenuData.m_6413_(0));
                tag.m_128365_("inventory", (Tag)this.Inventory.serializeNBT());
            }

            public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                this.MenuData.m_8050_(0, tag.m_128451_("color"));
                if (tag.m_128441_("inventory")) {
                    this.Inventory.deserializeNBT(tag.m_128469_("inventory"));
                }
            }

            @NotNull
            public CompoundTag getClientPacketData(CoreBlockEntity coreBlockEntity) {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("color", this.MenuData.m_6413_(0));
                return tag;
            }

            public void handleClientPacketData(CoreBlockEntity coreBlockEntity, CompoundTag tag) {
                this.MenuData.m_8050_(0, tag.m_128451_("color"));
            }

            public ColorSource getColor() {
                return new ColorSource.Arbitrary(this.MenuData.m_6413_(0));
            }

            public void setColor(ColorSource color) {
                this.MenuData.m_8050_(0, color.getColor());
            }

            public static class Container
            extends SimpleItemContainer {
                public Container() {
                    this(null);
                }

                public Container(Runnable runnable) {
                    super(7, runnable);
                }

                public boolean isValid(int slot, @NotNull ItemStack stack) {
                    Item item;
                    if (!super.isValid(slot, stack)) {
                        return false;
                    }
                    if (slot == 0) {
                        return stack.m_41720_() instanceof IModuleStorage;
                    }
                    ItemStack storageStack = this.get(0);
                    if (storageStack.m_41619_() || !((item = stack.m_41720_()) instanceof IModule)) {
                        return false;
                    }
                    IModule module = (IModule)item;
                    return storageStack.m_41720_() instanceof IModuleStorage && module.isValidFor(storageStack);
                }
            }
        }
    }
}

