/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.utils.handlers.DummyFluidHandler;
import tv.soaryn.xycraft.core.utils.handlers.DummyItemHandler;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachineRecipes;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.recipe.ExtractorRecipe;

public class ExtractorBlockEntity
extends CoreBlockEntity
implements ITickable.Server,
ExtractorRecipe.Container {
    LazyOptional<IItemHandler> externalItemOptional = LazyOptional.empty();
    LazyOptional<IFluidHandler> externalFluidOptional = LazyOptional.empty();
    private long prevTick = 0L;

    public ExtractorBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Extractor.entity(), pos, state);
        this.Data = new ExtractorData();
        this.revalidate();
    }

    public ExtractorData getData() {
        return (ExtractorData)this.Data;
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(ExtractorBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    private static int compareAdjacentCounts(ExtractorRecipe r1, ExtractorRecipe r2) {
        return Integer.compare(r2.getAdjCount(), r1.getAdjCount());
    }

    public void revalidate() {
        ExtractorData data = this.getData();
        data.AdjacentPos = this.getAdjacentBlockPos();
        data.TargetPos = this.getTargetPos();
        data.CatalystPos = this.getCatalystPos();
    }

    public BlockPos[] getAdjacentBlockPos() {
        BlockPos[] positions = new BlockPos[4];
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
        BlockPos pos = this.m_58899_().m_121945_(direction);
        int i = 0;
        for (Direction d : Direction.values()) {
            if (d.m_122434_() == direction.m_122434_()) continue;
            positions[i++] = pos.m_121945_(d);
        }
        return positions;
    }

    public BlockPos getTargetPos() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
        return this.m_58899_().m_121945_(direction);
    }

    public BlockPos getCatalystPos() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
        return this.m_58899_().m_5484_(direction, 2);
    }

    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity inventoryBlockEntity;
        long gameTime = level.m_46467_();
        if (this.prevTick == gameTime) {
            return;
        }
        this.prevTick = gameTime;
        ExtractorData data = this.getData();
        MachineStatusColors currentStatus = (MachineStatusColors)((Object)state.m_61143_(MachineStateProperties.Status));
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
        BlockPos posOfInventory = pos.m_121945_(direction.m_122424_());
        boolean passiveTick = ITickable.shouldTick((Level)level, (int)data.Seed, (int)((Integer)MachinesConfig.ExtractorRevalidateFrequency.get()));
        if (passiveTick) {
            this.checkForValidRecipe(level);
        }
        if ((inventoryBlockEntity = level.m_7702_(posOfInventory)) != null) {
            if (!this.externalFluidOptional.isPresent()) {
                this.externalFluidOptional = inventoryBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction);
            }
            if (!this.externalItemOptional.isPresent()) {
                this.externalItemOptional = inventoryBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction);
            }
        } else {
            this.externalFluidOptional.invalidate();
            this.externalItemOptional.invalidate();
        }
        this.m_6596_();
        boolean hasExternalBuffer = this.externalItemOptional.resolve().isPresent() || this.externalFluidOptional.resolve().isPresent();
        MachineStatusColors resultedStatus = MachineStatusColors.Success;
        if (level.m_276867_(pos)) {
            resultedStatus = MachineStatusColors.Off;
        } else if (data.RecipeCache == null) {
            resultedStatus = MachineStatusColors.Error;
        } else if (!hasExternalBuffer) {
            resultedStatus = MachineStatusColors.Idle;
        } else {
            if (currentStatus == MachineStatusColors.Idle || currentStatus == MachineStatusColors.Success) {
                resultedStatus = currentStatus;
            }
            if (data.IsBuffering) {
                resultedStatus = MachineStatusColors.Idle;
            }
        }
        BlockState newState = state;
        if (data.RecipeCache != null) {
            IOMode target;
            IOMode iOMode = target = data.RecipeCache.isFluidRecipe() ? IOMode.Fluid : IOMode.Item;
            if (target != state.m_61143_(MachineStateProperties.IOMode)) {
                newState = (BlockState)newState.m_61124_(MachineStateProperties.IOMode, (Comparable)((Object)target));
            }
        }
        if (resultedStatus != MachineStatusColors.Off && resultedStatus != MachineStatusColors.Error && hasExternalBuffer && (!data.IsBuffering && data.ProcessingTime > 0 && data.CurrentStep++ >= data.ProcessingTime || data.IsBuffering && passiveTick)) {
            boolean buffering = false;
            if (data.RecipeCache.isFluidRecipe()) {
                if (this.externalFluidOptional.resolve().isPresent()) {
                    FluidStack result;
                    IFluidHandler handler = (IFluidHandler)this.externalFluidOptional.resolve().get();
                    int filled = handler.fill(result = data.RecipeCache.assembleFluid(this, level.m_9598_()), IFluidHandler.FluidAction.EXECUTE);
                    buffering = filled < result.getAmount();
                }
            } else {
                Optional handlerCapability = this.externalItemOptional.resolve();
                if (handlerCapability.isPresent()) {
                    ItemStack result;
                    IItemHandler handler = (IItemHandler)handlerCapability.get();
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)(result = data.RecipeCache.assemble(this, level.m_9598_())), (boolean)false);
                    boolean bl = buffering = !remainder.m_41619_();
                }
            }
            if (buffering != data.IsBuffering) {
                data.IsBuffering = buffering;
                this.m_6596_();
            }
            if (!data.IsBuffering) {
                data.CurrentStep = 0;
                resultedStatus = MachineStatusColors.Success;
                this.m_6596_();
            } else {
                resultedStatus = MachineStatusColors.Idle;
            }
        }
        if (resultedStatus != currentStatus) {
            currentStatus = resultedStatus;
            newState = (BlockState)newState.m_61124_(MachineStateProperties.Status, (Comparable)((Object)currentStatus));
        }
        if (newState != state) {
            level.m_46597_(pos, newState);
        }
    }

    private MachineStatusColors validateStatus(@NotNull Level level, BlockPos pos) {
        ExtractorData data = this.getData();
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
        BlockPos posOfInventory = pos.m_121945_(direction.m_122424_());
        BlockEntity inventoryBlockEntity = level.m_7702_(posOfInventory);
        if (level.m_276867_(pos)) {
            return MachineStatusColors.Off;
        }
        if (data.RecipeCache == null) {
            return MachineStatusColors.Error;
        }
        if (inventoryBlockEntity == null) {
            return MachineStatusColors.Idle;
        }
        boolean buffering = false;
        if (data.RecipeCache.isFluidRecipe()) {
            LazyOptional optional = inventoryBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction);
            Optional handlerCapability = optional.resolve();
            if (handlerCapability.isPresent()) {
                FluidStack result;
                IFluidHandler handler = (IFluidHandler)handlerCapability.get();
                int filled = handler.fill(result = data.RecipeCache.assembleFluid(this, level.m_9598_()), IFluidHandler.FluidAction.SIMULATE);
                buffering = filled < result.getAmount();
            }
        } else {
            LazyOptional optional = inventoryBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction);
            Optional handlerCapability = optional.resolve();
            if (handlerCapability.isPresent()) {
                ItemStack result;
                IItemHandler handler = (IItemHandler)handlerCapability.get();
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)(result = data.RecipeCache.assemble(this, level.m_9598_())), (boolean)true);
                buffering = !remainder.m_41619_();
            }
        }
        return buffering ? MachineStatusColors.Idle : MachineStatusColors.Success;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
    }

    private void checkForValidRecipe(@NotNull Level level) {
        level.m_7465_().m_44013_((RecipeType)MachineRecipes.ExtractorCatalystType.get()).stream().filter(recipe -> recipe.matches(this, level)).max(ExtractorBlockEntity::compareAdjacentCounts).ifPresentOrElse(this::setRecipe, () -> level.m_7465_().m_44013_((RecipeType)MachineRecipes.ExtractorType.get()).stream().filter(recipe -> recipe.matches(this, level)).max(ExtractorBlockEntity::compareAdjacentCounts).ifPresentOrElse(this::setRecipe, this::resetRecipe));
    }

    public void setRecipe(ExtractorRecipe recipe) {
        IOMode target;
        ExtractorData data = this.getData();
        if (data.RecipeCache != null && recipe.m_6423_().equals((Object)data.RecipeCache.m_6423_())) {
            return;
        }
        data.RecipeCache = recipe;
        data.ProcessingTime = recipe.getTicks();
        data.CurrentStep = 0;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockState state = this.m_58900_();
        IOMode iOMode = target = recipe.isFluidRecipe() ? IOMode.Fluid : IOMode.Item;
        if (target == state.m_61143_(MachineStateProperties.IOMode)) {
            return;
        }
        BlockState newState = (BlockState)state.m_61124_(MachineStateProperties.IOMode, (Comparable)((Object)target));
        level.m_46597_(this.f_58858_, newState);
    }

    public void resetRecipe() {
        ExtractorData data = this.getData();
        data.RecipeCache = null;
        data.ProcessingTime = 0;
        data.CurrentStep = 0;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (((Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection)).m_122424_() == side) {
            ExtractorData data = this.getData();
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return data.FluidHandle.cast();
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return data.ItemHandle.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection);
    }

    @Override
    public FluidState getFluidState() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76145_() : Fluids.f_76191_.m_76145_();
    }

    @Override
    public BlockState getTarget() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.getData().TargetPos);
    }

    @Override
    public BlockState getCatalyst() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.getData().CatalystPos);
    }

    @Override
    public List<BlockState> computeAdjacent() {
        assert (this.f_58857_ != null);
        return Arrays.stream(this.getData().AdjacentPos).map(pos -> this.f_58857_.m_8055_(pos)).collect(Collectors.toCollection(ArrayList::new));
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
    }

    public boolean m_6542_(@NotNull Player player) {
        return false;
    }

    public void m_6211_() {
    }

    @Deprecated
    public static Iterable<BlockPos> areaInFront(BlockPos origin, Direction direction) {
        if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
            return BlockPos.m_121940_((BlockPos)origin.m_7918_(-1, -1, -1).m_5484_(direction, 2), (BlockPos)origin.m_7918_(1, 1, 1));
        }
        return BlockPos.m_121940_((BlockPos)origin.m_7918_(-1, -1, -1), (BlockPos)origin.m_7918_(1, 1, 1).m_5484_(direction, 2));
    }

    public static class ExtractorData
    implements IDataSync {
        public DummyFluidHandler FluidHandle = new DummyFluidHandler();
        public DummyItemHandler ItemHandle = new DummyItemHandler();
        private BlockPos TargetPos;
        private BlockPos[] AdjacentPos;
        private BlockPos CatalystPos;
        public ExtractorRecipe RecipeCache;
        public boolean IsBuffering;
        public int ProcessingTime = 0;
        public int CurrentStep = 0;
        public int Seed;

        public void onLoad(CoreBlockEntity coreBlockEntity) {
            ExtractorBlockEntity extractorEntity = (ExtractorBlockEntity)coreBlockEntity;
            this.Seed = extractorEntity.m_58899_().hashCode();
            extractorEntity.revalidate();
            Level level = extractorEntity.m_58904_();
            if (level != null) {
                BlockPos pos = extractorEntity.m_58899_();
                extractorEntity.checkForValidRecipe(level);
                MachineStatusColors status = extractorEntity.validateStatus(level, extractorEntity.m_58899_());
                BlockState state = extractorEntity.m_58900_();
                if (state.m_61143_(MachineStateProperties.Status) != status) {
                    BlockState newState = (BlockState)state.m_61124_(MachineStateProperties.Status, (Comparable)((Object)status));
                    level.markAndNotifyBlock(pos, level.m_46745_(pos), newState, newState, 3, 512);
                    level.m_46597_(pos, newState);
                }
                Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
                BlockPos posOfInventory = pos.m_121945_(direction.m_122424_());
                BlockEntity inventoryBlockEntity = level.m_7702_(posOfInventory);
                ExtractorData.revalidateInventory(extractorEntity, direction, inventoryBlockEntity);
            }
        }

        static void revalidateInventory(ExtractorBlockEntity extractorEntity, Direction direction, BlockEntity inventoryBlockEntity) {
            if (inventoryBlockEntity != null) {
                if (!extractorEntity.externalFluidOptional.isPresent()) {
                    extractorEntity.externalFluidOptional = inventoryBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction);
                }
                if (!extractorEntity.externalItemOptional.isPresent()) {
                    extractorEntity.externalItemOptional = inventoryBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction);
                }
            } else {
                extractorEntity.externalFluidOptional.invalidate();
                extractorEntity.externalItemOptional.invalidate();
            }
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            tag.m_128405_("process_time", this.ProcessingTime);
            tag.m_128405_("step", this.CurrentStep);
            tag.m_128405_("seed", this.Seed);
            tag.m_128379_("is_buffering", this.IsBuffering);
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            this.ProcessingTime = tag.m_128451_("process_time");
            this.CurrentStep = tag.m_128451_("step");
            this.Seed = tag.m_128451_("seed");
            this.IsBuffering = tag.m_128471_("is_buffering");
            ExtractorBlockEntity extractorEntity = (ExtractorBlockEntity)coreBlockEntity;
            extractorEntity.revalidate();
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            this.ItemHandle.invalidate();
            this.FluidHandle.invalidate();
        }
    }
}

