/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.content.capabilities.player.ColorCapability;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.FabricatorBlockEntity;

public class FabricatorBlock
extends XyBlock.WithEntity
implements IColored,
ITickable {
    public FabricatorBlock() {
        super(MachinesContent.MachineProperties().m_60955_(), () -> ((BlockContent)MachinesContent.Fabricator).entity());
        this.m_49966_().m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{CoreStateProperties.StateDirection});
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_43719_();
        if (ModifierKeyCapability.of((Player)ctx.m_43723_())) {
            direction = direction.m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)direction);
    }

    public boolean m_7923_(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        InteractionResult wrenchResult;
        BlockEntity be = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(interactionHand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (interactionHand == InteractionHand.MAIN_HAND && dyeColor != null) {
            ColorSource.Dye color = new ColorSource.Dye(dyeColor);
            if (be instanceof FabricatorBlockEntity) {
                FabricatorBlockEntity fabricator = (FabricatorBlockEntity)be;
                if (color.getColor() != fabricator.getData().getColor().getColor()) {
                    fabricator.getData().setColor((ColorSource)color);
                    be.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_46597_(pos, state);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
        }
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)stack, (boolean)true) && (wrenchResult = IWrenchUse.rotate((BlockState)state, (Level)level, (BlockPos)pos, (BlockHitResult)hitResult)) != null) {
            return wrenchResult;
        }
        if (!level.m_5776_() && be instanceof FabricatorBlockEntity) {
            FabricatorBlockEntity fabricator = (FabricatorBlockEntity)be;
            if (!(player instanceof FakePlayer)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)fabricator, (BlockPos)be.m_58899_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (entity == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FabricatorBlockEntity) {
                FabricatorBlockEntity fabricator = (FabricatorBlockEntity)blockEntity;
                ColorSource.Arbitrary color = new ColorSource.Arbitrary(ColorCapability.colorOf((Player)player));
                DyeColor dye = DyeColor.getColor((ItemStack)player.m_21206_());
                if (dye != null) {
                    color = new ColorSource.Dye(dye);
                }
                fabricator.getData().setColor((ColorSource)color);
                fabricator.m_6596_();
                level.m_46597_(pos, state);
                level.m_7260_(pos, state, state, 3);
                level.markAndNotifyBlock(pos, level.m_46745_(pos), state, state, 3, 512);
            }
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof FabricatorBlockEntity) {
            FabricatorBlockEntity entity = (FabricatorBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)entity.getData().Inventory.asVanillaContainer());
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FabricatorBlockEntity) {
            FabricatorBlockEntity fabricator = (FabricatorBlockEntity)blockEntity;
            FabricatorBlockEntity.FabricatorData data = fabricator.getData();
            int color = data.getColor().getColor();
            Level entityLevel = fabricator.m_58904_();
            return data.canCraft(entityLevel, pos) ? color : ColorUtils.multiply((int)color, (float)0.4f);
        }
        return super.getColorOfBlock(state, level, pos, index);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return ColorCapability.colorOf((Player)Utils.getClientPlayer());
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != ((Direction)state.m_61143_((Property)CoreStateProperties.StateDirection)).m_122424_();
    }
}

