/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular.modules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import tv.soaryn.xycraft.machines.content.items.modular.modules.AttributeModifierRecord;
import tv.soaryn.xycraft.machines.content.items.modular.modules.ModuleItem;

public class AttributeModuleItem
extends ModuleItem {
    public static final EquipmentSlot[] ALL = EquipmentSlot.values();
    public static final EquipmentSlot[] ARMOR = new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.HEAD, EquipmentSlot.LEGS};
    public static final EquipmentSlot[] HANDS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    private final ImmutableMap<EquipmentSlot, ImmutableMultimap<Attribute, AttributeModifier>> _attributes;

    public AttributeModuleItem(AttributeModifierRecord ... records) {
        ImmutableMap.Builder slotBuilder = ImmutableMap.builder();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
            Arrays.stream(records).filter(attributeModifierRecord -> Arrays.asList(attributeModifierRecord.validSlots()).contains(slot)).map(attributeModifierRecord -> attributeModifierRecord.getEntry(slot)).forEach(arg_0 -> ((ImmutableMultimap.Builder)attributeBuilder).put(arg_0));
            slotBuilder.put((Object)slot, (Object)attributeBuilder.build());
        }
        this._attributes = slotBuilder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiersFromModule(EquipmentSlot slot, ItemStack stack) {
        return (Multimap)this._attributes.get((Object)slot);
    }

    public static AttributeModuleItem armor() {
        return new AttributeModuleItem(new AttributeModifierRecord(Attributes.f_22284_, "module.attribute.armor", "Armor", 2.0, AttributeModifier.Operation.ADDITION, ARMOR), new AttributeModifierRecord(Attributes.f_22285_, "module.attribute.toughness", "Toughness", 2.0, AttributeModifier.Operation.ADDITION, ARMOR));
    }

    public static AttributeModuleItem reach() {
        return new AttributeModuleItem(new AttributeModifierRecord((Attribute)ForgeMod.BLOCK_REACH.get(), "module.attribute.reach", "Block Reach", 1.0, AttributeModifier.Operation.ADDITION, EquipmentSlot.MAINHAND));
    }
}

