/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.data.MachineBlockStateDataGen;
import tv.soaryn.xycraft.machines.data.MachineItemModelDataGen;
import tv.soaryn.xycraft.machines.data.MachineItemTagDataGen;
import tv.soaryn.xycraft.machines.data.MachineLanguageDataGen;
import tv.soaryn.xycraft.machines.data.MachinesBlockLoot;
import tv.soaryn.xycraft.machines.data.MachinesBlockTagDataGen;
import tv.soaryn.xycraft.machines.data.MachinesFluidTagDataGen;
import tv.soaryn.xycraft.machines.data.MachinesRecipeDataGen;

@Mod.EventBusSubscriber(modid="xycraft_machines", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MachineDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new MachinesRecipeDataGen(output));
        if (event.includeServer()) {
            MachinesBlockTagDataGen blockTag = new MachinesBlockTagDataGen(output, lookup, "xycraft_machines", existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTag);
            generator.addProvider(true, (DataProvider)new MachinesFluidTagDataGen(output, lookup, "xycraft_machines", existingFileHelper));
            generator.addProvider(true, (DataProvider)new MachineItemTagDataGen(output, lookup, blockTag.m_274426_(), "xycraft_machines", existingFileHelper));
            generator.addProvider(true, (DataProvider)MachinesBlockLoot.supplier(output));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new MachineLanguageDataGen(output, "xycraft_machines", "en_us"));
            generator.addProvider(true, (DataProvider)new MachineBlockStateDataGen(output, MachinesContent.Map, "xycraft_machines", existingFileHelper));
            generator.addProvider(true, (DataProvider)new MachineItemModelDataGen(output, "xycraft_machines", existingFileHelper));
        }
    }
}

