/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.mojang.blaze3d.Blaze3D;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class OptionDescriptionWidget
extends AbstractWidget {
    private static final int AUTO_SCROLL_TIMER = 1500;
    private static final float AUTO_SCROLL_SPEED = 1.0f;
    @Nullable
    private DescriptionWithName description;
    private List<FormattedCharSequence> wrappedText;
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Font font = OptionDescriptionWidget.minecraft.f_91062_;
    private Supplier<ScreenRectangle> dimensions;
    private float targetScrollAmount;
    private float currentScrollAmount;
    private int maxScrollAmount;
    private int descriptionY;
    private int lastInteractionTime;
    private boolean scrollingBackward;

    public OptionDescriptionWidget(Supplier<ScreenRectangle> dimensions, @Nullable DescriptionWithName description) {
        super(0, 0, 0, 0, (Component)(description == null ? Component.m_237119_() : description.name()));
        this.dimensions = dimensions;
        this.setOptionDescription(description);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Style hoveredStyle;
        Object image;
        if (this.description == null) {
            return;
        }
        this.currentScrollAmount = Mth.m_14179_((float)(delta * 0.5f), (float)this.currentScrollAmount, (float)this.targetScrollAmount);
        ScreenRectangle dimensions = this.dimensions.get();
        this.m_252865_(dimensions.m_274563_());
        this.m_253211_(dimensions.m_274449_());
        this.f_93618_ = dimensions.f_263770_();
        this.f_93619_ = dimensions.f_263800_();
        int y = this.m_252907_();
        int nameWidth = font.m_92852_((FormattedText)this.description.name());
        if (nameWidth > this.m_5711_()) {
            Component component = this.description.name();
            int n = this.m_252754_();
            int n2 = this.m_252754_() + this.m_5711_();
            Objects.requireNonNull(font);
            OptionDescriptionWidget.m_280138_((GuiGraphics)graphics, (Font)font, (Component)component, (int)n, (int)y, (int)n2, (int)(y + 9), (int)-1);
        } else {
            graphics.m_280430_(font, this.description.name(), this.m_252754_(), y, 0xFFFFFF);
        }
        Objects.requireNonNull(font);
        graphics.m_280588_(this.m_252754_(), y += 5 + 9, this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_());
        y -= (int)this.currentScrollAmount;
        if (this.description.description().image().isDone() && ((Optional)(image = this.description.description().image().join())).isPresent()) {
            y += ((ImageRenderer)((Optional)image).get()).render(graphics, this.m_252754_(), y, this.m_5711_(), delta) + 5;
        }
        if (this.wrappedText == null) {
            this.wrappedText = font.m_92923_((FormattedText)this.description.description().text(), this.m_5711_());
        }
        this.descriptionY = y;
        for (FormattedCharSequence line : this.wrappedText) {
            graphics.m_280648_(font, line, this.m_252754_(), y, 0xFFFFFF);
            Objects.requireNonNull(font);
            y += 9;
        }
        graphics.m_280618_();
        this.maxScrollAmount = Math.max(0, y + (int)this.currentScrollAmount - this.m_252907_() - this.m_93694_());
        if (this.m_198029_()) {
            this.lastInteractionTime = this.currentTimeMS();
        }
        if ((hoveredStyle = this.getDescStyle(mouseX, mouseY)) != null && hoveredStyle.m_131186_() != null) {
            graphics.m_280304_(font, hoveredStyle, mouseX, mouseY);
        }
        if (this.m_93696_()) {
            graphics.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), -1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Style clickedStyle = this.getDescStyle((int)mouseX, (int)mouseY);
        if (clickedStyle != null && clickedStyle.m_131182_() != null) {
            if (OptionDescriptionWidget.minecraft.f_91080_.m_5561_(clickedStyle)) {
                this.m_7435_(minecraft.m_91106_());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double vertical) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.targetScrollAmount = Mth.m_14036_((float)(this.targetScrollAmount - (float)((int)vertical * 10)), (float)0.0f, (float)this.maxScrollAmount);
            this.lastInteractionTime = this.currentTimeMS();
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_93696_()) {
            switch (keyCode) {
                case 265: {
                    this.targetScrollAmount = Mth.m_14036_((float)(this.targetScrollAmount - 10.0f), (float)0.0f, (float)this.maxScrollAmount);
                    break;
                }
                case 264: {
                    this.targetScrollAmount = Mth.m_14036_((float)(this.targetScrollAmount + 10.0f), (float)0.0f, (float)this.maxScrollAmount);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.description != null) {
            this.description.description().image().getNow(Optional.empty()).ifPresent(ImageRenderer::tick);
        }
        Objects.requireNonNull(font);
        float pxPerTick = 0.05f * 9.0f;
        if (this.maxScrollAmount > 0 && this.currentTimeMS() - this.lastInteractionTime > 1500) {
            if (this.scrollingBackward) {
                if (this.targetScrollAmount + (pxPerTick *= -1.0f) < 0.0f) {
                    this.scrollingBackward = false;
                    this.lastInteractionTime = this.currentTimeMS();
                }
            } else if (this.targetScrollAmount + pxPerTick > (float)this.maxScrollAmount) {
                this.scrollingBackward = true;
                this.lastInteractionTime = this.currentTimeMS();
            }
            this.targetScrollAmount = Mth.m_14036_((float)(this.targetScrollAmount + pxPerTick), (float)0.0f, (float)this.maxScrollAmount);
        }
    }

    private Style getDescStyle(int mouseX, int mouseY) {
        if (!this.m_93680_(mouseX, mouseY)) {
            return null;
        }
        int x = mouseX - this.m_252754_();
        int y = mouseY - this.descriptionY;
        if (x < 0 || x > this.m_252754_() + this.m_5711_()) {
            return null;
        }
        if (y < 0 || y > this.m_252907_() + this.m_93694_()) {
            return null;
        }
        Objects.requireNonNull(font);
        int line = y / 9;
        if (line >= this.wrappedText.size()) {
            return null;
        }
        return font.m_92865_().m_92338_(this.wrappedText.get(line), x);
    }

    protected void m_168797_(NarrationElementOutput builder2) {
        if (this.description != null) {
            builder2.m_169146_(NarratedElementType.TITLE, this.description.name());
            builder2.m_169146_(NarratedElementType.HINT, this.description.description().text());
        }
    }

    public void setOptionDescription(DescriptionWithName description) {
        this.description = description;
        this.wrappedText = null;
        this.targetScrollAmount = 0.0f;
        this.currentScrollAmount = 0.0f;
        this.lastInteractionTime = this.currentTimeMS();
    }

    private int currentTimeMS() {
        return (int)(Blaze3D.m_83640_() * 1000.0);
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        return null;
    }
}

